/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp3;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.audio.mp3.MP3AudioHeader;
import org.jaudiotagger.logging.AbstractTagDisplayFormatter;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.logging.PlainTextTagDisplayFormatter;
import org.jaudiotagger.logging.XMLTagDisplayFormatter;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.TagNotFoundException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.id3.AbstractTag;
import org.jaudiotagger.tag.id3.ID3v11Tag;
import org.jaudiotagger.tag.id3.ID3v1Tag;
import org.jaudiotagger.tag.id3.ID3v22Tag;
import org.jaudiotagger.tag.id3.ID3v23Tag;
import org.jaudiotagger.tag.id3.ID3v24Tag;
import org.jaudiotagger.tag.lyrics3.AbstractLyrics3;

public class MP3File
extends AudioFile {
    private static final int MINIMUM_FILESIZE = 150;
    protected static AbstractTagDisplayFormatter tagFormatter;
    private AbstractID3v2Tag id3v2tag = null;
    private ID3v24Tag id3v2Asv24tag = null;
    private AbstractLyrics3 lyrics3tag = null;
    private ID3v1Tag id3v1tag = null;
    public static final int LOAD_IDV1TAG = 2;
    public static final int LOAD_IDV2TAG = 4;
    public static final int LOAD_LYRICS3 = 8;
    public static final int LOAD_ALL = 14;

    public MP3File() {
    }

    public MP3File(String filename) throws IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        this(new File(filename));
    }

    public MP3File(File file, int loadOptions) throws IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        this(file, loadOptions, false);
    }

    private void readV1Tag(File file, RandomAccessFile newFile, int loadOptions) throws IOException {
        if ((loadOptions & 2) != 0) {
            try {
                this.id3v1tag = new ID3v11Tag(newFile, file.getName());
            }
            catch (TagNotFoundException ex) {
                // empty catch block
            }
            try {
                if (this.id3v1tag == null) {
                    this.id3v1tag = new ID3v1Tag(newFile, file.getName());
                }
            }
            catch (TagNotFoundException ex) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readV2Tag(File file, int loadOptions) throws IOException, TagException {
        int startByte = (int)((MP3AudioHeader)this.audioHeader).getMp3StartByte();
        if (startByte >= 10) {
            FileInputStream fis = null;
            AbstractInterruptibleChannel fc = null;
            ByteBuffer bb = null;
            try {
                fis = new FileInputStream(file);
                fc = fis.getChannel();
                bb = ByteBuffer.allocate(startByte);
                ((FileChannel)fc).read(bb);
            }
            finally {
                if (fc != null) {
                    fc.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            bb.rewind();
            if ((loadOptions & 4) != 0) {
                try {
                    this.setID3v2Tag(new ID3v24Tag(bb, file.getName()));
                }
                catch (TagNotFoundException ex) {
                    // empty catch block
                }
                try {
                    if (this.id3v2tag == null) {
                        this.setID3v2Tag(new ID3v23Tag(bb, file.getName()));
                    }
                }
                catch (TagNotFoundException ex) {
                    // empty catch block
                }
                try {
                    if (this.id3v2tag == null) {
                        this.setID3v2Tag(new ID3v22Tag(bb, file.getName()));
                    }
                }
                catch (TagNotFoundException ex) {
                    // empty catch block
                }
            }
        }
    }

    private void readLyrics3Tag(File file, RandomAccessFile newFile, int loadOptions) throws IOException {
    }

    private MP3AudioHeader checkAudioStart(long startByte, MP3AudioHeader currentHeader) throws IOException, InvalidAudioFrameException {
        MP3AudioHeader newAudioHeader = new MP3AudioHeader(this.file, 0L);
        if (currentHeader.getMp3StartByte() == newAudioHeader.getMp3StartByte()) {
            return currentHeader;
        }
        if (currentHeader.getNumberOfFrames() != newAudioHeader.getNumberOfFrames()) {
            MP3AudioHeader nextAudioHeader = new MP3AudioHeader(this.file, newAudioHeader.getMp3StartByte() + (long)newAudioHeader.mp3FrameHeader.getFrameLength());
            if (nextAudioHeader.getMp3StartByte() == currentHeader.getMp3StartByte()) {
                return currentHeader;
            }
            if (nextAudioHeader.getNumberOfFrames() == newAudioHeader.getNumberOfFrames()) {
                return newAudioHeader;
            }
            return newAudioHeader;
        }
        return newAudioHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MP3File(File file, int loadOptions, boolean readOnly) throws IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        RandomAccessFile newFile = null;
        try {
            this.file = file;
            newFile = this.checkFilePermissions(file, readOnly);
            long startByte = AbstractID3v2Tag.getV2TagSizeIfExists(file);
            this.audioHeader = new MP3AudioHeader(file, startByte);
            if (startByte != ((MP3AudioHeader)this.audioHeader).getMp3StartByte()) {
                this.audioHeader = this.checkAudioStart(startByte, (MP3AudioHeader)this.audioHeader);
            }
            this.readV1Tag(file, newFile, loadOptions);
            this.readV2Tag(file, loadOptions);
            if (this.getID3v2Tag() != null) {
                this.tag = this.getID3v2Tag();
            } else if (this.id3v1tag != null) {
                this.tag = this.id3v1tag;
            }
        }
        finally {
            if (newFile != null) {
                newFile.close();
            }
        }
    }

    public long getMP3StartByte(File file) throws InvalidAudioFrameException, IOException {
        try {
            long startByte = AbstractID3v2Tag.getV2TagSizeIfExists(file);
            MP3AudioHeader audioHeader = new MP3AudioHeader(file, startByte);
            if (startByte != audioHeader.getMp3StartByte()) {
                audioHeader = this.checkAudioStart(startByte, audioHeader);
            }
            return audioHeader.getMp3StartByte();
        }
        catch (InvalidAudioFrameException iafe) {
            throw iafe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    public File extractID3v2TagDataIntoFile(File outputFile) throws TagNotFoundException, IOException {
        int startByte = (int)((MP3AudioHeader)this.audioHeader).getMp3StartByte();
        if (startByte >= 0) {
            FileInputStream fis = new FileInputStream(this.file);
            FileChannel fc = fis.getChannel();
            ByteBuffer bb = ByteBuffer.allocate(startByte);
            fc.read(bb);
            FileOutputStream out = new FileOutputStream(outputFile);
            out.write(bb.array());
            out.close();
            fc.close();
            fis.close();
            return outputFile;
        }
        throw new TagNotFoundException("There is no ID3v2Tag data in this file");
    }

    public MP3AudioHeader getMP3AudioHeader() {
        return (MP3AudioHeader)this.getAudioHeader();
    }

    public boolean hasID3v1Tag() {
        return this.id3v1tag != null;
    }

    public boolean hasID3v2Tag() {
        return this.id3v2tag != null;
    }

    public MP3File(File file) throws IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        this(file, 14);
    }

    public void setID3v1Tag(ID3v1Tag id3v1tag) {
        this.id3v1tag = id3v1tag;
    }

    public void setID3v1Tag(Tag id3v1tag) {
        this.id3v1tag = (ID3v1Tag)id3v1tag;
    }

    public void setID3v1Tag(AbstractTag mp3tag) {
        this.id3v1tag = new ID3v11Tag(mp3tag);
    }

    public ID3v1Tag getID3v1Tag() {
        return this.id3v1tag;
    }

    public void setID3v2Tag(AbstractTag mp3tag) {
        this.id3v2tag = new ID3v24Tag(mp3tag);
    }

    public void setID3v2Tag(AbstractID3v2Tag id3v2tag) {
        this.id3v2tag = id3v2tag;
        this.id3v2Asv24tag = id3v2tag instanceof ID3v24Tag ? (ID3v24Tag)this.id3v2tag : new ID3v24Tag((AbstractTag)id3v2tag);
    }

    public void setID3v2TagOnly(AbstractID3v2Tag id3v2tag) {
        this.id3v2tag = id3v2tag;
        this.id3v2Asv24tag = null;
    }

    public AbstractID3v2Tag getID3v2Tag() {
        return this.id3v2tag;
    }

    public ID3v24Tag getID3v2TagAsv24() {
        return this.id3v2Asv24tag;
    }

    public void delete(AbstractTag mp3tag) throws FileNotFoundException, IOException {
        mp3tag.delete(new RandomAccessFile(this.file, "rw"));
    }

    public void save() throws IOException, TagException {
        this.save(this.file);
    }

    @Override
    public void commit() throws CannotWriteException {
        try {
            this.save();
        }
        catch (IOException ioe) {
            throw new CannotWriteException(ioe);
        }
        catch (TagException te) {
            throw new CannotWriteException(te);
        }
    }

    public void precheck(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException(ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE_FILE_NOT_FOUND.getMsg(file.getName()));
        }
        if (!file.canWrite()) {
            throw new IOException(ErrorMessage.GENERAL_WRITE_FAILED.getMsg(file.getName()));
        }
        if (file.length() <= 150L) {
            throw new IOException(ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE_FILE_IS_TOO_SMALL.getMsg(file.getName()));
        }
    }

    public void save(File file) throws IOException {
        this.precheck(file);
        RandomAccessFile rfile = null;
        try {
            if (TagOptionSingleton.getInstance().isId3v2Save()) {
                if (this.id3v2tag == null) {
                    rfile = new RandomAccessFile(file, "rw");
                    new ID3v24Tag().delete(rfile);
                    new ID3v23Tag().delete(rfile);
                    new ID3v22Tag().delete(rfile);
                    rfile.close();
                } else {
                    this.id3v2tag.write(file, ((MP3AudioHeader)this.getAudioHeader()).getMp3StartByte());
                }
            }
            rfile = new RandomAccessFile(file, "rw");
            if (TagOptionSingleton.getInstance().isLyrics3Save() && this.lyrics3tag != null) {
                this.lyrics3tag.write(rfile);
            }
            if (TagOptionSingleton.getInstance().isId3v1Save()) {
                if (this.id3v1tag == null) {
                    new ID3v1Tag().delete(rfile);
                } else {
                    this.id3v1tag.write(rfile);
                }
            }
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (IOException iex) {
            throw iex;
        }
        catch (RuntimeException re) {
            throw re;
        }
        finally {
            if (rfile != null) {
                rfile.close();
            }
        }
    }

    @Override
    public String displayStructureAsXML() {
        MP3File.createXMLStructureFormatter();
        tagFormatter.openHeadingElement("file", this.getFile().getAbsolutePath());
        if (this.getID3v1Tag() != null) {
            this.getID3v1Tag().createStructure();
        }
        if (this.getID3v2Tag() != null) {
            this.getID3v2Tag().createStructure();
        }
        tagFormatter.closeHeadingElement("file");
        return tagFormatter.toString();
    }

    @Override
    public String displayStructureAsPlainText() {
        MP3File.createPlainTextStructureFormatter();
        tagFormatter.openHeadingElement("file", this.getFile().getAbsolutePath());
        if (this.getID3v1Tag() != null) {
            this.getID3v1Tag().createStructure();
        }
        if (this.getID3v2Tag() != null) {
            this.getID3v2Tag().createStructure();
        }
        tagFormatter.closeHeadingElement("file");
        return tagFormatter.toString();
    }

    private static void createXMLStructureFormatter() {
        tagFormatter = new XMLTagDisplayFormatter();
    }

    private static void createPlainTextStructureFormatter() {
        tagFormatter = new PlainTextTagDisplayFormatter();
    }

    public static AbstractTagDisplayFormatter getStructureFormatter() {
        return tagFormatter;
    }

    @Override
    public void setTag(Tag tag) {
        this.tag = tag;
        if (tag instanceof ID3v1Tag) {
            this.setID3v1Tag((ID3v1Tag)tag);
        } else {
            this.setID3v2Tag((AbstractID3v2Tag)tag);
        }
    }

    @Override
    public Tag createDefaultTag() {
        return new ID3v23Tag();
    }
}

