/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.audio.alaw;

import com.lti.utils.UnsignedUtils;

public class ALawEncoderUtil {
    public static final int MAX = Short.MAX_VALUE;
    private static byte[] pcmToALawMap = new byte[65536];

    private static byte encode(int pcm) {
        int sign = (pcm & 0x8000) >> 8;
        if (sign != 0) {
            pcm = -pcm;
        }
        if (pcm > Short.MAX_VALUE) {
            pcm = Short.MAX_VALUE;
        }
        int exponent = 7;
        int expMask = 16384;
        while ((pcm & expMask) == 0 && exponent > 0) {
            --exponent;
            expMask >>= 1;
        }
        int mantissa = pcm >> (exponent == 0 ? 4 : exponent + 3) & 0xF;
        byte alaw = (byte)(sign | exponent << 4 | mantissa);
        return (byte)(alaw ^ 0xD5);
    }

    public static byte aLawEncode(int pcm) {
        return pcmToALawMap[UnsignedUtils.uShortToInt((short)(pcm & 0xFFFF))];
    }

    public static byte aLawEncode(short pcm) {
        return pcmToALawMap[UnsignedUtils.uShortToInt(pcm)];
    }

    public static void aLawEncode(boolean bigEndian, byte[] data, int offset, int length, byte[] target) {
        if (bigEndian) {
            ALawEncoderUtil.aLawEncodeBigEndian(data, offset, length, target);
        } else {
            ALawEncoderUtil.aLawEncodeLittleEndian(data, offset, length, target);
        }
    }

    public static void aLawEncodeLittleEndian(byte[] data, int offset, int length, byte[] target) {
        int size = length / 2;
        for (int i = 0; i < size; ++i) {
            target[i] = ALawEncoderUtil.aLawEncode((data[offset + 2 * i + 1] & 0xFF) << 8 | data[offset + 2 * i] & 0xFF);
        }
    }

    public static void aLawEncodeBigEndian(byte[] data, int offset, int length, byte[] target) {
        int size = length / 2;
        for (int i = 0; i < size; ++i) {
            target[i] = ALawEncoderUtil.aLawEncode(data[offset + 2 * i + 1] & 0xFF | (data[offset + 2 * i] & 0xFF) << 8);
        }
    }

    static {
        for (int i = Short.MIN_VALUE; i <= Short.MAX_VALUE; ++i) {
            ALawEncoderUtil.pcmToALawMap[UnsignedUtils.uShortToInt((short)((short)i))] = ALawEncoderUtil.encode(i);
        }
    }
}

