/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.gui.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.media.Control;
import javax.media.Controller;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.StartEvent;
import javax.media.StopEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import net.sf.fmj.ejmf.toolkit.util.SourcedTimer;
import net.sf.fmj.ejmf.toolkit.util.SourcedTimerEvent;
import net.sf.fmj.ejmf.toolkit.util.SourcedTimerListener;
import net.sf.fmj.ejmf.toolkit.util.TimeSource;

public class TimeDisplayControl
implements Control,
SourcedTimerListener,
TimeSource,
ControllerListener {
    private JLabel timerField = new JLabel("0:00:00", 4);
    private JPanel controlComponent = new JPanel();
    private String timeVal;
    private SourcedTimer timer;
    private Controller controller;
    private long divisor;

    public TimeDisplayControl(Controller controller) {
        this.controller = controller;
        this.timer = new SourcedTimer(this);
        this.timer.addSourcedTimerListener(this);
        this.divisor = this.timer.getConversionDivisor();
        controller.addControllerListener(this);
        this.setUpControlComponent();
        this.timeVal = this.convertTime(this.getTime(), this.divisor);
        this.loadTime();
    }

    public TimeDisplayControl(Controller controller, SourcedTimer timer) {
        this.controller = controller;
        this.timer = timer;
        timer.addSourcedTimerListener(this);
        this.divisor = timer.getConversionDivisor();
        controller.addControllerListener(this);
        this.setUpControlComponent();
        this.timeVal = this.convertTime(this.getTime(), this.divisor);
        this.loadTime();
    }

    public Component getControlComponent() {
        return this.controlComponent;
    }

    private void setUpControlComponent() {
        JLabel timeLabel = new JLabel("Media Time:", 4);
        JPanel mainPanel = new JPanel();
        int GAP = 10;
        EmptyBorder emptyBorder = new EmptyBorder(GAP, GAP, GAP, GAP);
        CompoundBorder etchedBorder = new CompoundBorder(new EtchedBorder(), emptyBorder);
        TitledBorder titledBorder = new TitledBorder(etchedBorder, "Time Display Control");
        mainPanel.setBorder(titledBorder);
        mainPanel.setLayout(new BorderLayout(GAP, GAP));
        mainPanel.add((Component)timeLabel, "Center");
        mainPanel.add((Component)this.timerField, "East");
        this.controlComponent.add(mainPanel);
    }

    private String convertTime(long longTime, long d) {
        int hr = 0;
        int min = 0;
        long sec = longTime / d;
        min = (int)(sec / 60L);
        if (min > 0) {
            if (min > 60) {
                hr = min / 60;
                min %= 60;
            }
            sec %= 60L;
        }
        String t = hr + ":";
        t = min < 10 ? t + 0 + min + ":" : t + min + ":";
        t = sec < 10L ? t + 0 + sec : t + sec;
        return t;
    }

    private void loadTime() {
        this.timerField.setText(this.timeVal);
    }

    public void timerUpdate(SourcedTimerEvent e) {
        this.timeVal = this.convertTime(this.getTime(), this.divisor);
        SwingUtilities.invokeLater(new LoadTimeThread());
    }

    public void controllerUpdate(ControllerEvent e) {
        if (e instanceof StopEvent || e instanceof ControllerErrorEvent) {
            this.timer.stop();
        } else if (e instanceof StartEvent) {
            this.timer.start();
        }
    }

    public long getTime() {
        return this.controller.getMediaNanoseconds();
    }

    public long getConversionDivisor() {
        return 1000000000L;
    }

    class LoadTimeThread
    implements Runnable {
        LoadTimeThread() {
        }

        public void run() {
            TimeDisplayControl.this.loadTime();
        }
    }
}

