/*
 * Decompiled with CFR 0.152.
 */
package javazoom.spi.mpeg.sampled.convert;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RandomAudioInputStream
extends InputStream {
    private RandomAccessFile file;
    private long pos;

    public RandomAudioInputStream(RandomAccessFile file) {
        this.file = file;
        this.pos = 0L;
    }

    @Override
    public int read() throws IOException {
        int a = this.file.read();
        ++this.pos;
        return a;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.file == null) {
            return -1;
        }
        int r = this.file.read(b, off, len);
        this.pos += (long)r;
        return r;
    }

    @Override
    public int available() throws IOException {
        return (int)(this.file.length() - this.pos);
    }

    @Override
    public long skip(long l) throws IOException {
        this.file.seek(l);
        this.pos = l;
        return l;
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }
}

