/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.malware;

import com.google.inject.Inject;
import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.ComFailException;
import com.jacob.com.ComThread;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import com.limegroup.gnutella.malware.VirusDefinitionManager;
import com.limegroup.gnutella.malware.VirusScanException;
import com.limegroup.gnutella.malware.VirusScanner;
import com.limegroup.gnutella.malware.VirusUtils;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.limewire.concurrent.SimpleTimer;
import org.limewire.core.settings.ApplicationSettings;
import org.limewire.core.settings.DownloadSettings;
import org.limewire.core.settings.FilterSettings;
import org.limewire.inject.EagerSingleton;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.setting.IntSetting;
import org.limewire.setting.PropertiesSetting;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

@EagerSingleton
class VirusScannerImpl
implements VirusScanner,
Service {
    private static final String LIBRARY_VERSION = "1.7.8426";
    private static final Log LOG = LogFactory.getLog(VirusScannerImpl.class);
    private final VirusDefinitionManager virusDefinitionManager;
    private final ScheduledExecutorService queue;
    private volatile Boolean supported = null;
    private volatile int definitionsVersion = -1;
    private boolean comInitialized = false;
    private Dispatch avg = null;

    @Inject
    VirusScannerImpl(VirusDefinitionManager virusDefinitionManager) {
        LOG.debug("Creating VirusScannerImpl");
        this.virusDefinitionManager = virusDefinitionManager;
        this.queue = new SimpleTimer("VirusScannerThread", true);
    }

    @Inject
    public void register(ServiceRegistry serviceRegistry) {
        serviceRegistry.register(this);
    }

    @Override
    public void initialize() {
    }

    @Override
    public void start() {
    }

    @Override
    public String getServiceName() {
        return "AntiVirusService";
    }

    @Override
    public void stop() {
        Future<Void> stop = this.queue.submit(new StopCommand());
        try {
            stop.get();
        }
        catch (ExecutionException e) {
            LOG.debug("Failed to stop", e);
        }
        catch (InterruptedException e) {
            LOG.debug("Failed to stop", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSupported() {
        if (this.supported == null) {
            VirusScannerImpl virusScannerImpl = this;
            synchronized (virusScannerImpl) {
                if (this.supported == null) {
                    this.supported = LimeWireUtils.isTemporaryDirectoryInUse() ? Boolean.valueOf(false) : (!LimeWireUtils.isPro() && ApplicationSettings.AVG_REMOVE_FROM_FREE_VERSION_5_4.getValue() ? Boolean.valueOf(false) : (!FilterSettings.USE_VIRUS_SCANNER.getValue() ? Boolean.valueOf(false) : (!OSUtils.isAVGCompatibleWindows() ? Boolean.valueOf(false) : (LimeWireUtils.isTestingVersion() ? Boolean.valueOf(FilterSettings.TEST_VIRUS_SCANNER.getValue()) : Boolean.valueOf(LimeWireUtils.isPro() || LimeWireUtils.isBetaRelease())))));
                    LOG.debugf("Supported: {0}", (Object)this.supported);
                }
            }
        }
        return this.supported;
    }

    private String readLicense() {
        try {
            return new String(new byte[]{76, 105, 99, 66, 101, 103, 44, 32, 86, 101, 114, 61, 49, 46, 48, 44, 32, 78, 97, 109, 101, 61, 34, 76, 105, 109, 101, 87, 105, 114, 101, 34, 44, 32, 69, 120, 112, 61, 50, 48, 49, 50, 45, 49, 49, 45, 49, 57, 44, 32, 83, 105, 103, 110, 61, 100, 54, 108, 98, 120, 102, 100, 122, 84, 88, 65, 106, 111, 81, 52, 110, 107, 79, 75, 89, 85, 99, 104, 47, 86, 69, 68, 49, 78, 67, 118, 53, 55, 120, 49, 69, 97, 48, 97, 122, 106, 110, 89, 114, 118, 50, 80, 87, 86, 110, 104, 69, 49, 100, 76, 90, 70, 72, 74, 87, 71, 55, 71, 122, 122, 51, 88, 90, 76, 82, 72, 74, 112, 76, 70, 57, 104, 113, 101, 120, 99, 70, 69, 75, 48, 100, 98, 57, 110, 82, 112, 103, 50, 115, 47, 53, 115, 85, 117, 104, 86, 88, 121, 50, 84, 103, 116, 79, 87, 101, 48, 110, 81, 81, 113, 71, 71, 52, 57, 82, 107, 108, 73, 76, 68, 72, 108, 85, 119, 104, 113, 84, 83, 74, 122, 82, 75, 90, 112, 71, 74, 97, 70, 57, 51, 57, 90, 70, 87, 90, 89, 75, 70, 70, 79, 51, 85, 97, 54, 76, 72, 108, 47, 120, 95, 79, 50, 70, 53, 89, 73, 44, 32, 76, 105, 99, 69, 110, 100}, "UTF8");
        }
        catch (UnsupportedEncodingException ignored) {
            File licenseFile = VirusUtils.getLicenseFile();
            byte[] licence = FileUtils.readFileFully(licenseFile);
            if (licence == null) {
                LOG.debugf("Error reading license file: {0}", (Object)licenseFile);
                return "";
            }
            return new String(licence);
        }
    }

    private boolean initializeLazily() throws VirusScanException {
        if (this.avg != null) {
            return true;
        }
        if (this.definitionsVersion == 0) {
            throw new VirusScanException("No virus definitions", VirusScanException.Detail.DOWNLOADING_DEFINITIONS);
        }
        try {
            ComThread.InitMTA();
            this.comInitialized = true;
            this.avg = new ActiveXComponent("AvgSdkCom.AvgSdk", 4).getObject();
            Dispatch.call((Dispatch)this.avg, (String)"InitializeLicense", (Object)this.readLicense());
        }
        catch (ComFailException e) {
            this.uninitialize();
            int hr = e.getHResult();
            LOG.debugf(e, "Failed to initialize: {0}", hr);
            throw new VirusScanException("hr: " + hr, e);
        }
        File db = VirusUtils.getDatabaseDirectory();
        try {
            Dispatch.call((Dispatch)this.avg, (String)"LoadVdbFiles", (Object)db.getAbsolutePath());
        }
        catch (ComFailException e) {
            this.uninitialize();
            FileUtils.forceDeleteRecursive(db);
            this.definitionsVersion = 0;
            this.virusDefinitionManager.checkForDefinitions();
            int hr = e.getHResult();
            LOG.debugf(e, "Failed to load definitions: {0}", hr);
            throw new VirusScanException("hr: " + hr, e);
        }
        return true;
    }

    @Override
    public int getDefinitionsVersion() {
        if (this.definitionsVersion == -1) {
            File db = VirusUtils.getDatabaseDirectory();
            File nfo = new File(db, "version.nfo");
            try {
                String version = VirusUtils.getNfoValue(nfo, "VDB_RELEASE_VERSION");
                this.definitionsVersion = Integer.parseInt(version);
            }
            catch (FileNotFoundException e) {
                LOG.debug("Cannot find version.nfo");
                this.definitionsVersion = 0;
            }
            catch (IOException e) {
                LOG.debug("Cannot find VBD_RELEASE_VERSION");
                this.definitionsVersion = 0;
            }
            catch (NumberFormatException e) {
                LOG.debug("Cannot parse VDB_RELEASE_VERSION");
                this.definitionsVersion = 0;
            }
        }
        LOG.debugf("Virus definitions version {0}", (Object)this.definitionsVersion);
        return this.definitionsVersion;
    }

    @Override
    public String getLibraryVersion() {
        return LIBRARY_VERSION;
    }

    @Override
    public boolean isInfected(File file) throws VirusScanException {
        assert (this.isSupported());
        Future<Boolean> infected = this.queue.submit(new ScanCommand(file));
        try {
            boolean result = infected.get();
            return result;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof VirusScanException) {
                throw (VirusScanException)e.getCause();
            }
            throw new VirusScanException(e);
        }
        catch (InterruptedException e) {
            throw new VirusScanException(e);
        }
    }

    private void updateStats(File file, boolean infected) {
        IntSetting numScannedInfected = DownloadSettings.NUM_SCANNED_INFECTED;
        IntSetting numScannedClean = DownloadSettings.NUM_SCANNED_CLEAN;
        PropertiesSetting infectedExtensions = DownloadSettings.INFECTED_EXTENSIONS;
        if (infected) {
            Integer numInfectedForExtension;
            numScannedInfected.set(numScannedInfected.get() + 1);
            String ext = FileUtils.getFileExtension(file);
            Properties props = infectedExtensions.get();
            String inf = props.getProperty(ext);
            Integer n = numInfectedForExtension = Integer.valueOf(inf != null ? Integer.valueOf(inf) : 0);
            Integer n2 = numInfectedForExtension = Integer.valueOf(numInfectedForExtension + 1);
            props.put(ext, numInfectedForExtension.toString());
            infectedExtensions.set(props);
        } else {
            numScannedClean.set(numScannedClean.get() + 1);
        }
    }

    @Override
    public void stopScanner() {
        this.stop();
    }

    @Override
    public void loadFullUpdate(File updateDir) throws VirusScanException {
        assert (this.isSupported());
        Future<Void> load = this.queue.submit(new LoadFullUpdateCommand(updateDir));
        try {
            load.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof VirusScanException) {
                throw (VirusScanException)e.getCause();
            }
            throw new VirusScanException(e);
        }
        catch (InterruptedException e) {
            throw new VirusScanException(e);
        }
    }

    @Override
    public void loadIncrementalUpdate(File updateDir) throws IOException, VirusScanException {
        assert (this.isSupported());
        Future<Void> load = this.queue.submit(new LoadIncrementalUpdateCommand(updateDir));
        try {
            load.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof VirusScanException) {
                throw (VirusScanException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new VirusScanException(e);
        }
        catch (InterruptedException e) {
            throw new VirusScanException(e);
        }
    }

    private void uninitialize() {
        if (this.avg != null) {
            LOG.debug("Releasing AvgSdk instance");
            this.avg.safeRelease();
            this.avg = null;
        }
        if (this.comInitialized) {
            try {
                LOG.debug("Uninitializing COM");
                ComThread.Release();
            }
            catch (ComFailException e) {
                int hr = e.getHResult();
                LOG.debugf(e, "Failed to uninitialize COM: {0}", hr);
            }
            this.comInitialized = false;
        }
    }

    private class LoadFullUpdateCommand
    implements Callable<Void> {
        private final File updateDir;

        LoadFullUpdateCommand(File updateDir) {
            this.updateDir = updateDir;
        }

        @Override
        public Void call() throws VirusScanException {
            LOG.debugf("Loading full update from {0}", (Object)this.updateDir);
            VirusScannerImpl.this.uninitialize();
            VirusScannerImpl.this.definitionsVersion = 0;
            File db = VirusUtils.getDatabaseDirectory();
            FileUtils.forceDeleteRecursive(db);
            db.mkdirs();
            db.mkdir();
            File[] files = this.updateDir.listFiles();
            if (files == null) {
                throw new VirusScanException("Update directory is empty");
            }
            for (File file : files) {
                if (file.renameTo(new File(db, file.getName()))) continue;
                throw new VirusScanException("Failed to rename file");
            }
            VirusScannerImpl.this.definitionsVersion = -1;
            VirusScannerImpl.this.getDefinitionsVersion();
            return null;
        }
    }

    private class LoadIncrementalUpdateCommand
    implements Callable<Void> {
        private final File updateDir;

        LoadIncrementalUpdateCommand(File updateDir) {
            this.updateDir = updateDir;
        }

        @Override
        public Void call() throws IOException, VirusScanException {
            LOG.debugf("Loading incremental update from {0}", (Object)this.updateDir);
            VirusScannerImpl.this.definitionsVersion = -1;
            if (!VirusScannerImpl.this.initializeLazily()) {
                throw new IOException("Failed to initialize");
            }
            File patch = null;
            File[] files = this.updateDir.listFiles();
            if (files == null) {
                throw new IOException("Update directory is empty");
            }
            for (File file : files) {
                if (!file.getName().endsWith(".trs")) continue;
                patch = file;
                break;
            }
            if (patch == null) {
                throw new IOException("Could not find patch file");
            }
            File db = VirusUtils.getDatabaseDirectory();
            File source = new File(db, "incavi.avm");
            if (!source.exists()) {
                throw new IOException("Could not find source file");
            }
            File temp = VirusUtils.getTemporaryDirectory();
            File destination = new File(temp, "incavi.avm");
            try {
                Dispatch avgVDBUpdate = new ActiveXComponent("AvgSdkCom.AvgVdbUpd", 4).getObject();
                Dispatch.call((Dispatch)avgVDBUpdate, (String)"UpdateIncrementalVdbFile", (Object)source.getAbsolutePath(), (Object)destination.getAbsolutePath(), (Object)1, (Object)patch.getAbsolutePath(), (Object)new Variant());
                avgVDBUpdate.safeRelease();
            }
            catch (ComFailException e) {
                int hr = e.getHResult();
                LOG.debugf(e, "Failed to merge incremental update: {0}", hr);
                throw new IOException("hr: " + hr, e);
            }
            VirusScannerImpl.this.definitionsVersion = 0;
            source.delete();
            if (!destination.renameTo(source)) {
                throw new VirusScanException("Failed to rename incavi.avm");
            }
            File newVersion = new File(this.updateDir, "version.nfo");
            File oldVersion = new File(db, "version.nfo");
            oldVersion.delete();
            if (!newVersion.renameTo(oldVersion)) {
                throw new VirusScanException("Failed to rename version.nfo");
            }
            try {
                Dispatch.call((Dispatch)VirusScannerImpl.this.avg, (String)"ReloadVdbFiles");
            }
            catch (ComFailException e) {
                int hr = e.getHResult();
                LOG.debugf(e, "Failed to reload definitions: {0}", hr);
                throw new VirusScanException("hr: " + hr, e);
            }
            VirusScannerImpl.this.definitionsVersion = -1;
            VirusScannerImpl.this.getDefinitionsVersion();
            return null;
        }
    }

    private class StopCommand
    implements Callable<Void> {
        private StopCommand() {
        }

        @Override
        public Void call() {
            VirusScannerImpl.this.uninitialize();
            return null;
        }
    }

    private class ScanCommand
    implements Callable<Boolean> {
        private final File file;

        ScanCommand(File file) {
            this.file = file;
        }

        @Override
        public Boolean call() throws VirusScanException {
            if (!this.file.exists()) {
                return false;
            }
            if (!VirusScannerImpl.this.initializeLazily()) {
                throw new VirusScanException("Failed to initialize");
            }
            try {
                Variant infected;
                Variant resultVar = new Variant();
                Dispatch params = new ActiveXComponent("AvgSdkCom.AvgScanParameters", 4).getObject();
                String path = this.file.getAbsolutePath();
                if (this.file.isDirectory()) {
                    LOG.debugf("Scanning directory: {0}", (Object)path);
                    infected = Dispatch.call((Dispatch)VirusScannerImpl.this.avg, (String)"ScanDirectory", (Object)path, (Object)resultVar, (Object)params);
                } else {
                    LOG.debugf("Scanning file: {0}", (Object)path);
                    infected = Dispatch.call((Dispatch)VirusScannerImpl.this.avg, (String)"ScanFile", (Object)path, (Object)path, (Object)resultVar, (Object)params);
                }
                params.safeRelease();
                boolean isInfected = infected.getBoolean();
                LOG.debugf("Infected: {0}", (Object)infected);
                VirusScannerImpl.this.updateStats(this.file, isInfected);
                return isInfected;
            }
            catch (ComFailException e) {
                int hr = e.getHResult();
                LOG.debugf(e, "Failed to scan {0}: {1}", this.file, hr);
                throw new VirusScanException("hr: " + hr, e);
            }
        }
    }
}

