/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.library;

import com.limegroup.gnutella.library.AbstractFileCollection;
import com.limegroup.gnutella.library.FileDesc;
import java.util.Iterator;
import java.util.NoSuchElementException;

class ThreadSafeFileViewIterator
implements Iterator<FileDesc> {
    private final AbstractFileCollection fileList;
    private int index = 0;
    private FileDesc preview;

    public ThreadSafeFileViewIterator(AbstractFileCollection fileList) {
        this.fileList = fileList;
        this.index = fileList.getMinIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean preview() {
        assert (this.preview == null);
        this.fileList.getReadLock().lock();
        try {
            while (this.index <= this.fileList.getMaxIndex()) {
                this.preview = this.fileList.getFileDescForIndex(this.index);
                ++this.index;
                if (this.preview == null) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.fileList.getReadLock().unlock();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.preview != null && !this.fileList.contains(this.preview)) {
            this.preview = null;
        }
        return this.preview != null || this.preview();
    }

    @Override
    public FileDesc next() {
        if (this.hasNext()) {
            FileDesc item = this.preview;
            this.preview = null;
            return item;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

