/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.filters.AllowFilter;
import com.limegroup.gnutella.filters.CompositeFilter;
import com.limegroup.gnutella.filters.DuplicateFilter;
import com.limegroup.gnutella.filters.GUIDFilter;
import com.limegroup.gnutella.filters.GreedyQueryFilter;
import com.limegroup.gnutella.filters.HashFilter;
import com.limegroup.gnutella.filters.HostileFilter;
import com.limegroup.gnutella.filters.KeywordFilter;
import com.limegroup.gnutella.filters.LocalIPFilter;
import com.limegroup.gnutella.filters.PhraseFilter;
import com.limegroup.gnutella.filters.RequeryFilter;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.filters.SpamFilterFactory;
import com.limegroup.gnutella.filters.SpamReplyFilter;
import com.limegroup.gnutella.filters.URNFilter;
import java.util.ArrayList;
import org.limewire.core.settings.FilterSettings;

@Singleton
class SpamFilterFactoryImpl
implements SpamFilterFactory {
    private final Provider<HostileFilter> hostileFilter;
    private final Provider<LocalIPFilter> ipFilter;
    private final Provider<URNFilter> urnFilter;

    @Inject
    public SpamFilterFactoryImpl(Provider<HostileFilter> hostileFilter, Provider<LocalIPFilter> ipFilter, Provider<URNFilter> urnFilter) {
        this.hostileFilter = hostileFilter;
        this.ipFilter = ipFilter;
        this.urnFilter = urnFilter;
    }

    @Override
    public SpamFilter createPersonalFilter() {
        ArrayList<SpamFilter> buf = new ArrayList<SpamFilter>();
        LocalIPFilter ipFilter = this.ipFilter.get();
        if (ipFilter.hasBlacklistedHosts()) {
            buf.add(ipFilter);
        }
        buf.add(new KeywordFilter());
        buf.add(new PhraseFilter());
        buf.add(new SpamReplyFilter());
        if (FilterSettings.FILTER_URNS.getValue()) {
            buf.add(this.urnFilter.get());
        }
        return SpamFilterFactoryImpl.compose(buf);
    }

    @Override
    public SpamFilter createRouteFilter() {
        ArrayList<SpamFilter> buf = new ArrayList<SpamFilter>();
        buf.add(new RequeryFilter());
        buf.add(new GUIDFilter());
        if (FilterSettings.FILTER_DUPLICATES.getValue()) {
            buf.add(new DuplicateFilter());
        }
        if (FilterSettings.FILTER_GREEDY_QUERIES.getValue()) {
            buf.add(new GreedyQueryFilter());
        }
        if (FilterSettings.FILTER_HASH_QUERIES.getValue()) {
            buf.add(new HashFilter());
        }
        buf.add(this.hostileFilter.get());
        return SpamFilterFactoryImpl.compose(buf);
    }

    private static SpamFilter compose(ArrayList<? extends SpamFilter> filters) {
        if (filters.size() == 0) {
            return new AllowFilter();
        }
        if (filters.size() == 1) {
            return filters.get(0);
        }
        SpamFilter[] delegates = new SpamFilter[filters.size()];
        return new CompositeFilter(filters.toArray(delegates));
    }
}

