/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.DownloadCallback;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.downloader.InNetworkDownloader;
import com.limegroup.gnutella.version.UpdateHandler;
import org.limewire.bittorrent.Torrent;

@Singleton
public class InNetworkCallback
implements DownloadCallback {
    private final UpdateHandler updateHandler;

    @Inject
    public InNetworkCallback(UpdateHandler updateHandler) {
        this.updateHandler = updateHandler;
    }

    @Override
    public void addDownload(Downloader d) {
    }

    @Override
    public void removeDownload(Downloader d) {
        InNetworkDownloader downloader = (InNetworkDownloader)d;
        this.updateHandler.inNetworkDownloadFinished(downloader.getSha1Urn(), downloader.getState() == Downloader.DownloadState.COMPLETE);
    }

    @Override
    public void downloadsComplete() {
    }

    @Override
    public void promptAboutUnscannedPreview(Downloader dloader) {
        dloader.discardUnscannedPreview(true);
    }

    @Override
    public boolean promptTorrentFilePriorities(Torrent torrent) {
        return true;
    }
}

