/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.BrowseHostHandler;
import com.limegroup.gnutella.BrowseHostHandlerManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.ResponseVerifier;
import com.limegroup.gnutella.SearchServices;
import com.limegroup.gnutella.filters.response.MutableGUIDFilter;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.search.QueryDispatcher;
import com.limegroup.gnutella.search.SearchResultHandler;
import com.limegroup.gnutella.statistics.OutOfBandStatistics;
import com.limegroup.gnutella.statistics.QueryStats;
import com.limegroup.gnutella.util.QueryUtils;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.core.api.Category;
import org.limewire.core.api.browse.BrowseListener;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.core.settings.FilterSettings;
import org.limewire.core.settings.MessageSettings;
import org.limewire.friend.api.FriendPresence;
import org.limewire.inspection.DataCategory;
import org.limewire.inspection.InspectionHistogram;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.GUID;
import org.limewire.util.DebugRunnable;
import org.limewire.util.I18NConvert;

@Singleton
public class SearchServicesImpl
implements SearchServices {
    private final Provider<ResponseVerifier> responseVerifier;
    private final Provider<QueryUnicaster> queryUnicaster;
    private final Provider<SearchResultHandler> searchResultHandler;
    private final Provider<MessageRouter> messageRouter;
    private final Provider<ConnectionServices> connectionServices;
    private final Provider<QueryDispatcher> queryDispatcher;
    private final Provider<MutableGUIDFilter> mutableGUIDFilter;
    private final Provider<QueryStats> queryStats;
    private final Provider<NetworkManager> networkManager;
    private final Provider<QueryRequestFactory> queryRequestFactory;
    private final BrowseHostHandlerManager browseHostHandlerManager;
    private final OutOfBandStatistics outOfBandStatistics;
    @InspectionPoint(value="searches by type", category=DataCategory.USAGE)
    private final InspectionHistogram<String> searchesByType = new InspectionHistogram();

    @Inject
    public SearchServicesImpl(Provider<ResponseVerifier> responseVerifier, Provider<QueryUnicaster> queryUnicaster, Provider<SearchResultHandler> searchResultHandler, Provider<MessageRouter> messageRouter, Provider<ConnectionServices> connectionServices, Provider<QueryDispatcher> queryDispatcher, Provider<MutableGUIDFilter> mutableGUIDFilter, Provider<QueryStats> queryStats, Provider<NetworkManager> networkManager, Provider<QueryRequestFactory> queryRequestFactory, BrowseHostHandlerManager browseHostHandlerManager, OutOfBandStatistics outOfBandStatistics) {
        this.responseVerifier = responseVerifier;
        this.queryUnicaster = queryUnicaster;
        this.searchResultHandler = searchResultHandler;
        this.messageRouter = messageRouter;
        this.connectionServices = connectionServices;
        this.queryDispatcher = queryDispatcher;
        this.mutableGUIDFilter = mutableGUIDFilter;
        this.queryStats = queryStats;
        this.networkManager = networkManager;
        this.queryRequestFactory = queryRequestFactory;
        this.browseHostHandlerManager = browseHostHandlerManager;
        this.outOfBandStatistics = outOfBandStatistics;
    }

    @Override
    public boolean isMandragoreWorm(byte[] guid, Response response) {
        return this.responseVerifier.get().isMandragoreWorm(guid, response);
    }

    @Override
    public boolean matchesQuery(byte[] guid, Response response) {
        return this.responseVerifier.get().matchesQuery(guid, response);
    }

    @Override
    public boolean matchesType(byte[] guid, Response response) {
        return this.responseVerifier.get().matchesType(guid, response);
    }

    @Override
    public void stopQuery(GUID guid) {
        this.queryUnicaster.get().purgeQuery(guid);
        this.searchResultHandler.get().removeQuery(guid);
        this.messageRouter.get().queryKilled(guid);
        if (this.connectionServices.get().isSupernode()) {
            this.queryDispatcher.get().addToRemove(guid);
        }
        this.mutableGUIDFilter.get().removeGUID(guid.bytes());
    }

    @Override
    public long getLastQueryTime() {
        return this.queryStats.get().getLastQueryTime();
    }

    private void recordAndSendQuery(QueryRequest qr, SearchCategory type) {
        this.queryStats.get().recordQuery();
        this.responseVerifier.get().record(qr, type);
        this.searchResultHandler.get().addQuery(qr);
        this.messageRouter.get().sendDynamicQuery(qr);
    }

    @Override
    public void queryWhatIsNew(byte[] guid, SearchCategory type) {
        QueryRequest qr = null;
        if (GUID.addressesMatch(guid, this.networkManager.get().getAddress(), this.networkManager.get().getPort())) {
            qr = this.queryRequestFactory.get().createWhatIsNewOOBQuery(guid, (byte)2, type);
            this.outOfBandStatistics.addSentQuery();
        } else {
            qr = this.queryRequestFactory.get().createWhatIsNewQuery(guid, (byte)2, type);
        }
        if (FilterSettings.FILTER_ADULT.getValue()) {
            this.mutableGUIDFilter.get().addGUID(guid);
        }
        this.recordAndSendQuery(qr, type);
    }

    @Override
    public void query(byte[] guid, String query, String richQuery, SearchCategory type) {
        QueryRequest qr = null;
        query = QueryUtils.removeIllegalChars(query);
        query = I18NConvert.instance().getNorm(query);
        if (query.length() > 0) {
            if (this.networkManager.get().isIpPortValid() && new GUID(guid).addressesMatch(this.networkManager.get().getAddress(), this.networkManager.get().getPort())) {
                qr = this.queryRequestFactory.get().createOutOfBandQuery(guid, query, richQuery, type);
                this.outOfBandStatistics.addSentQuery();
            } else {
                qr = this.queryRequestFactory.get().createQuery(guid, query, richQuery, type);
            }
            this.recordAndSendQuery(qr, type);
            Category category = type.getCategory();
            if (category != null) {
                this.searchesByType.count(category.getSchemaName());
            } else {
                this.searchesByType.count("no type");
            }
        }
    }

    @Override
    public void query(byte[] guid, String query) {
        this.query(guid, query, SearchCategory.ALL);
    }

    @Override
    public void query(byte[] guid, String query, SearchCategory type) {
        this.query(guid, query, "", type);
    }

    @Override
    public byte[] newQueryGUID() {
        byte[] ret = this.networkManager.get().isOOBCapable() && this.outOfBandStatistics.isOOBEffectiveForMe() ? GUID.makeAddressEncodedGuid(this.networkManager.get().getAddress(), this.networkManager.get().getPort()) : GUID.makeGuid();
        if (MessageSettings.STAMP_QUERIES.getValue()) {
            GUID.timeStampGuid(ret);
        }
        return ret;
    }

    @Override
    public String mutateQuery(String query) {
        return QueryUtils.mutateQuery(query);
    }

    @Override
    public BrowseHostHandler doAsynchronousBrowseHost(final FriendPresence friendPresence, GUID guid, final BrowseListener browseListener) {
        final BrowseHostHandler handler = this.browseHostHandlerManager.createBrowseHostHandler(guid);
        ThreadExecutor.startThread(new DebugRunnable(new Runnable(){

            @Override
            public void run() {
                handler.browseHost(friendPresence, browseListener);
            }
        }), "BrowseHoster");
        return handler;
    }
}

