/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.feed4j;

import it.sauronsoftware.feed4j.Constants;
import it.sauronsoftware.feed4j.TypeAbstract;
import it.sauronsoftware.feed4j.bean.Feed;
import it.sauronsoftware.feed4j.bean.FeedEnclosure;
import it.sauronsoftware.feed4j.bean.FeedHeader;
import it.sauronsoftware.feed4j.bean.FeedImage;
import it.sauronsoftware.feed4j.bean.FeedItem;
import it.sauronsoftware.feed4j.bean.RawElement;
import it.sauronsoftware.feed4j.bean.RawNode;
import it.sauronsoftware.feed4j.html.HTMLFragmentHelper;
import it.sauronsoftware.feed4j.html.HTMLOptimizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import org.dom4j.Document;
import org.dom4j.Element;

class TypeAtom_1_0
extends TypeAbstract {
    TypeAtom_1_0() {
    }

    public static Feed feed(URL source, Document document) {
        Element root = document.getRootElement();
        String nsuri = root.getNamespaceURI();
        Feed feed = new Feed();
        FeedHeader header = new FeedHeader();
        header.setURL(source);
        TypeAtom_1_0.populateRawElement((RawElement)header, root);
        String language = header.getAttributeValue("http://www.w3.org/XML/1998/namespace", "lang");
        if (language != null && TypeAtom_1_0.isValidLanguageCode(language)) {
            header.setLanguage(language);
        }
        int i = 0;
        while (i < header.getNodeCount()) {
            RawNode node = header.getNode(i);
            if (node instanceof RawElement) {
                RawElement element = (RawElement)node;
                String ensuri = element.getNamespaceURI();
                String ename = element.getName();
                if (ensuri.equals(nsuri)) {
                    FeedItem item;
                    if (ename.equals("title")) {
                        String title = TypeAtom_1_0.getValueAsTextPlain(element);
                        if (title != null) {
                            header.setTitle(title);
                        }
                    } else if (ename.equals("link")) {
                        URL link = TypeAtom_1_0.handleLink(element);
                        if (link != null) {
                            header.setLink(link);
                        }
                    } else if (ename.equals("logo")) {
                        String value = element.getValue();
                        if (value != null) {
                            try {
                                URL url = new URL(value);
                                FeedImage image = new FeedImage();
                                image.setURL(url);
                                header.setImage(image);
                            }
                            catch (MalformedURLException malformedURLException) {}
                        }
                    } else if (ename.equals("modified")) {
                        String modified = element.getValue();
                        if (modified != null) {
                            try {
                                header.setPubDate(Constants.ISO_8601_DATE_FORMAT.parse(modified));
                            }
                            catch (ParseException parseException) {}
                        }
                    } else if (ename.equals("entry") && (item = TypeAtom_1_0.handleEntry(source, element)) != null) {
                        feed.addItem(item);
                    }
                }
            }
            ++i;
        }
        RawElement[] rawentries = header.getElements(nsuri, "entry");
        int i2 = 0;
        while (i2 < rawentries.length) {
            header.removeNode(rawentries[i2]);
            ++i2;
        }
        feed.setHeader(header);
        return feed;
    }

    private static FeedItem handleEntry(URL source, RawElement entryElement) {
        String description;
        String nsuri = entryElement.getNamespaceURI();
        FeedItem item = new FeedItem();
        TypeAtom_1_0.populateRawElement((RawElement)item, entryElement);
        String summary = null;
        String content = null;
        String id = null;
        int i = 0;
        while (i < item.getNodeCount()) {
            RawNode node = item.getNode(i);
            if (node instanceof RawElement) {
                RawElement element = (RawElement)node;
                String ensuri = element.getNamespaceURI();
                String ename = element.getName();
                if (ensuri.equals(nsuri)) {
                    String modified;
                    String aux;
                    if (ename.equals("title")) {
                        String title = TypeAtom_1_0.getValueAsTextPlain(element);
                        if (title != null) {
                            item.setTitle(title);
                        }
                    } else if (ename.equals("link")) {
                        URL link = TypeAtom_1_0.handleLink(element);
                        if (link != null) {
                            item.setLink(link);
                        } else {
                            FeedEnclosure enclosure = TypeAtom_1_0.handleEnclosure(element);
                            if (enclosure != null) {
                                item.addEnclosure(enclosure);
                            }
                        }
                    } else if (ename.equals("id")) {
                        aux = element.getValue();
                        if (aux != null) {
                            id = aux;
                        }
                    } else if (ename.equals("summary")) {
                        aux = TypeAtom_1_0.getValueAsHTML(element);
                        if (aux != null) {
                            summary = aux;
                        }
                    } else if (ename.equals("content")) {
                        aux = TypeAtom_1_0.getValueAsHTML(element);
                        if (aux != null) {
                            content = aux;
                        }
                    } else if (ename.equals("issued")) {
                        modified = element.getValue();
                        if (modified != null) {
                            try {
                                item.setPubDate(Constants.ISO_8601_DATE_FORMAT.parse(modified));
                            }
                            catch (ParseException parseException) {}
                        }
                    } else if (ename.equals("modified") && (modified = element.getValue()) != null) {
                        try {
                            item.setPubDate(Constants.ISO_8601_DATE_FORMAT.parse(modified));
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                }
            }
            ++i;
        }
        if (item.getTitle() == null || item.getLink() == null) {
            return null;
        }
        if (summary == null) {
            summary = "";
        }
        if (content == null) {
            content = "";
        }
        String string = description = content.length() > summary.length() ? content : summary;
        if (description.length() > 0) {
            item.setDescriptionAsHTML(description);
            item.setDescriptionAsText(HTMLFragmentHelper.fromHTMLtoTextPlain(description));
        }
        if (id == null) {
            id = item.getLink().toExternalForm();
        }
        item.setGUID(TypeAtom_1_0.buildGUID(source.hashCode(), id.hashCode()));
        return item;
    }

    private static URL handleLink(RawElement linkElement) {
        String nsuri = linkElement.getNamespaceURI();
        String rel = linkElement.getAttributeValue(nsuri, "rel");
        if (rel != null && !rel.equalsIgnoreCase("alternate")) {
            return null;
        }
        String href = linkElement.getAttributeValue(nsuri, "href");
        if (href == null || href.length() == 0) {
            return null;
        }
        try {
            return new URL(href);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private static FeedEnclosure handleEnclosure(RawElement linkElement) {
        URL url;
        String nsuri = linkElement.getNamespaceURI();
        String rel = linkElement.getAttributeValue(nsuri, "rel");
        if (rel == null || !rel.equalsIgnoreCase("enclosure")) {
            return null;
        }
        String href = linkElement.getAttributeValue(nsuri, "href");
        if (href == null || href.length() == 0) {
            return null;
        }
        try {
            url = new URL(href);
        }
        catch (MalformedURLException e) {
            return null;
        }
        String type = linkElement.getAttributeValue(nsuri, "type");
        if (type == null || (type = type.trim()).length() == 0) {
            return null;
        }
        long length = -1L;
        String lengthStr = linkElement.getAttributeValue(nsuri, "length");
        if (lengthStr != null) {
            try {
                length = Long.parseLong(lengthStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String title = linkElement.getAttributeValue(nsuri, "title");
        FeedEnclosure enclosure = new FeedEnclosure();
        enclosure.setURL(url);
        enclosure.setMimeType(type);
        if (length > 0L) {
            enclosure.setLength(length);
        }
        if (title != null) {
            enclosure.setTitle(title);
        }
        return enclosure;
    }

    private static String getValueAsHTML(RawElement element) {
        String type = element.getAttributeValue(element.getNamespaceURI(), "type");
        if (type == null || type.length() == 0) {
            type = "text";
        }
        if (type.equals("text")) {
            String aux = element.getValue();
            if (aux != null) {
                if ((aux = aux.trim()).length() > 0) {
                    return HTMLFragmentHelper.fromTextPlainToHTML(aux);
                }
                return null;
            }
            return null;
        }
        if (type.equals("html")) {
            String aux = element.getValue();
            if (aux != null) {
                if ((aux = aux.trim()).length() > 0) {
                    if ((aux = HTMLOptimizer.optimize(aux)).length() > 0) {
                        return aux;
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
        if (type.equals("xhtml")) {
            String aux = HTMLFragmentHelper.fromXHTMLtoHTML(element);
            if (aux.length() > 0) {
                if ((aux = HTMLOptimizer.optimize(aux)).length() > 0) {
                    return aux;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private static String getValueAsTextPlain(RawElement element) {
        String type = element.getAttributeValue(element.getNamespaceURI(), "type");
        if (type == null || type.length() == 0) {
            type = "text";
        }
        if (type.equals("text")) {
            String aux = element.getValue();
            if (aux != null) {
                if ((aux = aux.trim()).length() > 0) {
                    return aux;
                }
                return null;
            }
            return null;
        }
        if (type.equals("html")) {
            String value = element.getValue();
            if (value != null && value.length() > 0) {
                String aux = HTMLFragmentHelper.fromHTMLtoTextPlain(value);
                if (aux.length() > 0) {
                    return aux;
                }
                return null;
            }
            return null;
        }
        if (type.equals("xhtml")) {
            String aux = HTMLFragmentHelper.fromXHTMLtoTextPlain(element);
            if (aux.length() > 0) {
                return aux;
            }
            return null;
        }
        return null;
    }
}

