/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pinyin4j;

import net.sourceforge.pinyin4j.ChineseToPinyinResource;
import net.sourceforge.pinyin4j.GwoyeuRomatzyhTranslator;
import net.sourceforge.pinyin4j.PinyinFormatter;
import net.sourceforge.pinyin4j.PinyinRomanizationTranslator;
import net.sourceforge.pinyin4j.PinyinRomanizationType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class PinyinHelper {
    public static String[] toHanyuPinyinStringArray(char c) {
        return PinyinHelper.getUnformattedHanyuPinyinStringArray(c);
    }

    public static String[] toHanyuPinyinStringArray(char c, HanyuPinyinOutputFormat hanyuPinyinOutputFormat) throws BadHanyuPinyinOutputFormatCombination {
        return PinyinHelper.getFormattedHanyuPinyinStringArray(c, hanyuPinyinOutputFormat);
    }

    private static String[] getFormattedHanyuPinyinStringArray(char c, HanyuPinyinOutputFormat hanyuPinyinOutputFormat) throws BadHanyuPinyinOutputFormatCombination {
        String[] stringArray = PinyinHelper.getUnformattedHanyuPinyinStringArray(c);
        if (null != stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = PinyinFormatter.formatHanyuPinyin(stringArray[i], hanyuPinyinOutputFormat);
            }
            return stringArray;
        }
        return null;
    }

    private static String[] getUnformattedHanyuPinyinStringArray(char c) {
        return ChineseToPinyinResource.getInstance().getHanyuPinyinStringArray(c);
    }

    public static String[] toTongyongPinyinStringArray(char c) {
        return PinyinHelper.convertToTargetPinyinStringArray(c, PinyinRomanizationType.TONGYONG_PINYIN);
    }

    public static String[] toWadeGilesPinyinStringArray(char c) {
        return PinyinHelper.convertToTargetPinyinStringArray(c, PinyinRomanizationType.WADEGILES_PINYIN);
    }

    public static String[] toMPS2PinyinStringArray(char c) {
        return PinyinHelper.convertToTargetPinyinStringArray(c, PinyinRomanizationType.MPS2_PINYIN);
    }

    public static String[] toYalePinyinStringArray(char c) {
        return PinyinHelper.convertToTargetPinyinStringArray(c, PinyinRomanizationType.YALE_PINYIN);
    }

    private static String[] convertToTargetPinyinStringArray(char c, PinyinRomanizationType pinyinRomanizationType) {
        String[] stringArray = PinyinHelper.getUnformattedHanyuPinyinStringArray(c);
        if (null != stringArray) {
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = PinyinRomanizationTranslator.convertRomanizationSystem(stringArray[i], PinyinRomanizationType.HANYU_PINYIN, pinyinRomanizationType);
            }
            return stringArray2;
        }
        return null;
    }

    public static String[] toGwoyeuRomatzyhStringArray(char c) {
        return PinyinHelper.convertToGwoyeuRomatzyhStringArray(c);
    }

    private static String[] convertToGwoyeuRomatzyhStringArray(char c) {
        String[] stringArray = PinyinHelper.getUnformattedHanyuPinyinStringArray(c);
        if (null != stringArray) {
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = GwoyeuRomatzyhTranslator.convertHanyuPinyinToGwoyeuRomatzyh(stringArray[i]);
            }
            return stringArray2;
        }
        return null;
    }

    public static String toHanyuPinyinString(String string, HanyuPinyinOutputFormat hanyuPinyinOutputFormat, String string2) throws BadHanyuPinyinOutputFormatCombination {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            String string3 = PinyinHelper.getFirstHanyuPinyinString(string.charAt(i), hanyuPinyinOutputFormat);
            if (null != string3) {
                stringBuffer.append(string3);
                if (i == string.length() - 1) continue;
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private static String getFirstHanyuPinyinString(char c, HanyuPinyinOutputFormat hanyuPinyinOutputFormat) throws BadHanyuPinyinOutputFormatCombination {
        String[] stringArray = PinyinHelper.getFormattedHanyuPinyinStringArray(c, hanyuPinyinOutputFormat);
        if (null != stringArray && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    private PinyinHelper() {
    }
}

