/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.ArrayList;

public abstract class HeaderFooter {
    protected String left;
    protected String center;
    protected String right;
    private boolean stripFields = false;
    public static final Field SHEET_NAME_FIELD = new Field("&A");
    public static final Field DATE_FIELD = new Field("&D");
    public static final Field FILE_FIELD = new Field("&F");
    public static final Field FULL_FILE_FIELD = new Field("&Z");
    public static final Field PAGE_FIELD = new Field("&P");
    public static final Field TIME_FIELD = new Field("&T");
    public static final Field NUM_PAGES_FIELD = new Field("&N");
    public static final Field PICTURE_FIELD = new Field("&G");
    public static final PairField BOLD_FIELD = new PairField("&B");
    public static final PairField ITALIC_FIELD = new PairField("&I");
    public static final PairField STRIKETHROUGH_FIELD = new PairField("&S");
    public static final PairField SUBSCRIPT_FIELD = new PairField("&Y");
    public static final PairField SUPERSCRIPT_FIELD = new PairField("&X");
    public static final PairField UNDERLINE_FIELD = new PairField("&U");
    public static final PairField DOUBLE_UNDERLINE_FIELD = new PairField("&E");

    protected HeaderFooter(String text) {
        block5: while (text != null && text.length() > 1) {
            int pos = text.length();
            switch (text.substring(1, 2).charAt(0)) {
                case 'L': {
                    if (text.indexOf("&C") >= 0) {
                        pos = Math.min(pos, text.indexOf("&C"));
                    }
                    if (text.indexOf("&R") >= 0) {
                        pos = Math.min(pos, text.indexOf("&R"));
                    }
                    this.left = text.substring(2, pos);
                    text = text.substring(pos);
                    continue block5;
                }
                case 'C': {
                    if (text.indexOf("&L") >= 0) {
                        pos = Math.min(pos, text.indexOf("&L"));
                    }
                    if (text.indexOf("&R") >= 0) {
                        pos = Math.min(pos, text.indexOf("&R"));
                    }
                    this.center = text.substring(2, pos);
                    text = text.substring(pos);
                    continue block5;
                }
                case 'R': {
                    if (text.indexOf("&C") >= 0) {
                        pos = Math.min(pos, text.indexOf("&C"));
                    }
                    if (text.indexOf("&L") >= 0) {
                        pos = Math.min(pos, text.indexOf("&L"));
                    }
                    this.right = text.substring(2, pos);
                    text = text.substring(pos);
                    continue block5;
                }
            }
            text = null;
        }
    }

    public String getLeft() {
        if (this.stripFields) {
            return HeaderFooter.stripFields(this.left);
        }
        return this.left;
    }

    public abstract void setLeft(String var1);

    public String getCenter() {
        if (this.stripFields) {
            return HeaderFooter.stripFields(this.center);
        }
        return this.center;
    }

    public abstract void setCenter(String var1);

    public String getRight() {
        if (this.stripFields) {
            return HeaderFooter.stripFields(this.right);
        }
        return this.right;
    }

    public abstract void setRight(String var1);

    public static String fontSize(short size) {
        return "&" + size;
    }

    public static String font(String font, String style) {
        return "&\"" + font + "," + style + "\"";
    }

    public static String page() {
        return HeaderFooter.PAGE_FIELD.sequence;
    }

    public static String numPages() {
        return HeaderFooter.NUM_PAGES_FIELD.sequence;
    }

    public static String date() {
        return HeaderFooter.DATE_FIELD.sequence;
    }

    public static String time() {
        return HeaderFooter.TIME_FIELD.sequence;
    }

    public static String file() {
        return HeaderFooter.FILE_FIELD.sequence;
    }

    public static String tab() {
        return HeaderFooter.SHEET_NAME_FIELD.sequence;
    }

    public static String startBold() {
        return HeaderFooter.BOLD_FIELD.sequence;
    }

    public static String endBold() {
        return HeaderFooter.BOLD_FIELD.sequence;
    }

    public static String startUnderline() {
        return HeaderFooter.UNDERLINE_FIELD.sequence;
    }

    public static String endUnderline() {
        return HeaderFooter.UNDERLINE_FIELD.sequence;
    }

    public static String startDoubleUnderline() {
        return HeaderFooter.DOUBLE_UNDERLINE_FIELD.sequence;
    }

    public static String endDoubleUnderline() {
        return HeaderFooter.DOUBLE_UNDERLINE_FIELD.sequence;
    }

    public static String stripFields(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        for (int i = 0; i < Field.ALL_FIELDS.size(); ++i) {
            int pos;
            String seq = ((Field)Field.ALL_FIELDS.get((int)i)).sequence;
            while ((pos = text.indexOf(seq)) > -1) {
                text = text.substring(0, pos) + text.substring(pos + seq.length());
            }
        }
        text = text.replaceAll("\\&\\d+", "");
        text = text.replaceAll("\\&\".*?,.*?\"", "");
        return text;
    }

    public boolean areFieldsStripped() {
        return this.stripFields;
    }

    public void setAreFieldsStripped(boolean stripFields) {
        this.stripFields = stripFields;
    }

    public static class PairField
    extends Field {
        private PairField(String sequence) {
            super(sequence);
        }
    }

    public static class Field {
        private static ArrayList ALL_FIELDS = new ArrayList();
        public final String sequence;

        private Field(String sequence) {
            this.sequence = sequence;
            ALL_FIELDS.add(this);
        }
    }
}

