/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public final class FontBasisRecord
extends Record {
    public static final short sid = 4192;
    private short field_1_xBasis;
    private short field_2_yBasis;
    private short field_3_heightBasis;
    private short field_4_scale;
    private short field_5_indexToFontTable;

    public FontBasisRecord() {
    }

    public FontBasisRecord(RecordInputStream in) {
        this.field_1_xBasis = in.readShort();
        this.field_2_yBasis = in.readShort();
        this.field_3_heightBasis = in.readShort();
        this.field_4_scale = in.readShort();
        this.field_5_indexToFontTable = in.readShort();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[FBI]\n");
        buffer.append("    .xBasis               = ").append("0x").append(HexDump.toHex(this.getXBasis())).append(" (").append(this.getXBasis()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .yBasis               = ").append("0x").append(HexDump.toHex(this.getYBasis())).append(" (").append(this.getYBasis()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .heightBasis          = ").append("0x").append(HexDump.toHex(this.getHeightBasis())).append(" (").append(this.getHeightBasis()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .scale                = ").append("0x").append(HexDump.toHex(this.getScale())).append(" (").append(this.getScale()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .indexToFontTable     = ").append("0x").append(HexDump.toHex(this.getIndexToFontTable())).append(" (").append(this.getIndexToFontTable()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/FBI]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)4192);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset + pos, this.field_1_xBasis);
        LittleEndian.putShort(data, 6 + offset + pos, this.field_2_yBasis);
        LittleEndian.putShort(data, 8 + offset + pos, this.field_3_heightBasis);
        LittleEndian.putShort(data, 10 + offset + pos, this.field_4_scale);
        LittleEndian.putShort(data, 12 + offset + pos, this.field_5_indexToFontTable);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 14;
    }

    public short getSid() {
        return 4192;
    }

    public Object clone() {
        FontBasisRecord rec = new FontBasisRecord();
        rec.field_1_xBasis = this.field_1_xBasis;
        rec.field_2_yBasis = this.field_2_yBasis;
        rec.field_3_heightBasis = this.field_3_heightBasis;
        rec.field_4_scale = this.field_4_scale;
        rec.field_5_indexToFontTable = this.field_5_indexToFontTable;
        return rec;
    }

    public short getXBasis() {
        return this.field_1_xBasis;
    }

    public void setXBasis(short field_1_xBasis) {
        this.field_1_xBasis = field_1_xBasis;
    }

    public short getYBasis() {
        return this.field_2_yBasis;
    }

    public void setYBasis(short field_2_yBasis) {
        this.field_2_yBasis = field_2_yBasis;
    }

    public short getHeightBasis() {
        return this.field_3_heightBasis;
    }

    public void setHeightBasis(short field_3_heightBasis) {
        this.field_3_heightBasis = field_3_heightBasis;
    }

    public short getScale() {
        return this.field_4_scale;
    }

    public void setScale(short field_4_scale) {
        this.field_4_scale = field_4_scale;
    }

    public short getIndexToFontTable() {
        return this.field_5_indexToFontTable;
    }

    public void setIndexToFontTable(short field_5_indexToFontTable) {
        this.field_5_indexToFontTable = field_5_indexToFontTable;
    }
}

