/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.portfolio;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.currency.Currency;
import org.yccheok.jstock.engine.currency.CurrencyPair;
import org.yccheok.jstock.file.ThreadSafeFileLock;

public class PortfolioRealTimeInfo {
    public final ConcurrentHashMap<Code, Double> stockPrices = new ConcurrentHashMap();
    public final ConcurrentHashMap<CurrencyPair, Double> exchangeRates = new ConcurrentHashMap();
    public final ConcurrentHashMap<Code, Currency> currencies = new ConcurrentHashMap();
    public final ConcurrentHashMap<Code, Double> changePrices = new ConcurrentHashMap();
    public final ConcurrentHashMap<Code, Double> changePricePercentages = new ConcurrentHashMap();
    public long stockPricesTimestamp = 0L;
    public long exchangeRatesTimestamp = 0L;
    public volatile transient boolean stockPricesDirty = false;
    public volatile transient boolean exchangeRatesDirty = false;
    public volatile transient boolean currenciesDirty = false;
    public volatile transient boolean changePricesDirty = false;
    public volatile transient boolean changePricePercentagesDirty = false;
    public volatile transient boolean stockPricesTimestampDirty = false;
    public volatile transient boolean exchangeRatesTimestampDirty = false;
    private static final Log log = LogFactory.getLog(PortfolioRealTimeInfo.class);

    public PortfolioRealTimeInfo() {
    }

    public PortfolioRealTimeInfo(PortfolioRealTimeInfo portfolioRealTimeInfo) {
        this.copy(portfolioRealTimeInfo);
    }

    private void copy(PortfolioRealTimeInfo portfolioRealTimeInfo) {
        this.stockPrices.clear();
        this.exchangeRates.clear();
        this.currencies.clear();
        this.changePrices.clear();
        this.changePricePercentages.clear();
        this.stockPrices.putAll(portfolioRealTimeInfo.stockPrices);
        this.exchangeRates.putAll(portfolioRealTimeInfo.exchangeRates);
        this.currencies.putAll(portfolioRealTimeInfo.currencies);
        this.changePrices.putAll(portfolioRealTimeInfo.changePrices);
        this.changePricePercentages.putAll(portfolioRealTimeInfo.changePricePercentages);
        this.stockPricesTimestamp = portfolioRealTimeInfo.stockPricesTimestamp;
        this.exchangeRatesTimestamp = portfolioRealTimeInfo.exchangeRatesTimestamp;
        this.stockPricesDirty = portfolioRealTimeInfo.stockPricesDirty;
        this.exchangeRatesDirty = portfolioRealTimeInfo.exchangeRatesDirty;
        this.currenciesDirty = portfolioRealTimeInfo.currenciesDirty;
        this.changePricesDirty = portfolioRealTimeInfo.changePricesDirty;
        this.changePricePercentagesDirty = portfolioRealTimeInfo.changePricePercentagesDirty;
        this.stockPricesTimestampDirty = portfolioRealTimeInfo.stockPricesTimestampDirty;
        this.exchangeRatesTimestampDirty = portfolioRealTimeInfo.exchangeRatesTimestampDirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean load(File file) {
        assert (file != null);
        if (!file.isFile()) {
            return false;
        }
        PortfolioRealTimeInfo portfolioRealTimeInfo = null;
        ThreadSafeFileLock.Lock lock = ThreadSafeFileLock.getLock(file);
        if (lock == null) {
            return false;
        }
        ThreadSafeFileLock.lockRead(lock);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
            Double value;
            Code code;
            Gson gson = PortfolioRealTimeInfo.getReadGson();
            portfolioRealTimeInfo = (PortfolioRealTimeInfo)gson.fromJson((Reader)reader, PortfolioRealTimeInfo.class);
            if (portfolioRealTimeInfo == null) {
                boolean bl = false;
                return bl;
            }
            for (Map.Entry<Code, Double> entry : portfolioRealTimeInfo.stockPrices.entrySet()) {
                code = entry.getKey();
                value = entry.getValue();
                if (code == null || value == null) {
                    boolean bl = false;
                    return bl;
                }
                if (code.toString() != null) continue;
                boolean bl = false;
                return bl;
            }
            for (Map.Entry<Object, Double> entry : portfolioRealTimeInfo.exchangeRates.entrySet()) {
                CurrencyPair currencyPair = (CurrencyPair)entry.getKey();
                value = entry.getValue();
                if (currencyPair == null || value == null) {
                    boolean bl = false;
                    return bl;
                }
                if (currencyPair.to() == null || currencyPair.from() == null) {
                    boolean bl = false;
                    return bl;
                }
                if (currencyPair.to().toString() != null && currencyPair.from().toString() != null) continue;
                boolean bl = false;
                return bl;
            }
            for (Map.Entry<Object, Comparable<Double>> entry : portfolioRealTimeInfo.currencies.entrySet()) {
                code = (Code)entry.getKey();
                Currency currency = (Currency)entry.getValue();
                if (code == null || currency == null) {
                    boolean bl = false;
                    return bl;
                }
                if (code.toString() != null && currency.toString() != null) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException ex) {
            log.error(null, (Throwable)ex);
        }
        catch (JsonSyntaxException ex) {
            log.error(null, (Throwable)ex);
        }
        catch (Exception ex) {
            log.error(null, (Throwable)ex);
        }
        finally {
            ThreadSafeFileLock.unlockRead(lock);
            ThreadSafeFileLock.releaseLock(lock);
        }
        if (portfolioRealTimeInfo == null) {
            return false;
        }
        this.copy(portfolioRealTimeInfo);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(File file) {
        Gson gson = PortfolioRealTimeInfo.getWriteGson();
        String string = gson.toJson((Object)this);
        ThreadSafeFileLock.Lock lock = ThreadSafeFileLock.getLock(file);
        if (lock == null) {
            return false;
        }
        ThreadSafeFileLock.lockWrite(lock);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));){
            writer.write(string);
        }
        catch (IOException ex) {
            log.error(null, (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            ThreadSafeFileLock.unlockWrite(lock);
            ThreadSafeFileLock.releaseLock(lock);
        }
        return true;
    }

    public static Gson getReadGson() {
        Gson gson = new GsonBuilder().registerTypeAdapter(new TypeToken<ConcurrentHashMap<Code, Double>>(){}.getType(), new ConcurrentHashMapInstanceCreator()).registerTypeAdapter(new TypeToken<ConcurrentHashMap<CurrencyPair, Double>>(){}.getType(), new ConcurrentHashMapInstanceCreator()).registerTypeAdapter(new TypeToken<ConcurrentHashMap<Code, Currency>>(){}.getType(), new ConcurrentHashMapInstanceCreator()).create();
        return gson;
    }

    public static Gson getWriteGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.enableComplexMapKeySerialization();
        Gson gson = builder.create();
        return gson;
    }

    private static class ConcurrentHashMapInstanceCreator<K, V>
    implements InstanceCreator<Map<K, V>> {
        private ConcurrentHashMapInstanceCreator() {
        }

        public Map<K, V> createInstance(Type type) {
            return new ConcurrentHashMap();
        }
    }
}

