/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.trading;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.animation.PauseTransition;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.ScheduledService;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import javafx.util.Duration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.trading.GUIUtils;
import org.yccheok.jstock.gui.trading.OrderSummary;
import org.yccheok.jstock.gui.trading.Portfolio;
import org.yccheok.jstock.internationalization.DriveWealthBundle;
import org.yccheok.jstock.trading.BuySell;
import org.yccheok.jstock.trading.OpenPosition;
import org.yccheok.jstock.trading.Utils;
import org.yccheok.jstock.trading.api.Account;
import org.yccheok.jstock.trading.api.ApiError;
import org.yccheok.jstock.trading.api.Instrument;
import org.yccheok.jstock.trading.api.MarketData;
import org.yccheok.jstock.trading.api.MarketDataManager;
import org.yccheok.jstock.trading.api.Order;
import org.yccheok.jstock.trading.api.OrderManager;
import org.yccheok.jstock.trading.api.SessionManager;
import org.yccheok.jstock.trading.api.User;

public class CreateOrderDlg {
    private static final Log log = LogFactory.getLog(CreateOrderDlg.class);
    private final OrderManager.OrderSide side;
    private final String symbol;
    private final String instrumentID;
    private final Double openQty;
    private String name;
    private String urlImage;
    private OrderManager.OrderType ordType;
    private final Dialog newOrdDlg = new Dialog();
    private Alert reviewDlg = null;
    private Alert resultDlg = null;
    private final TextField symbolTxt = new TextField();
    private final Label bidAskLbl = new Label();
    private final ChoiceBox<OrderManager.OrderType> ordTypeChoice = new ChoiceBox();
    private final Label amountQtyChoiceLbl = new Label();
    private final ChoiceBox<AmountQty> amountQtyChoice = new ChoiceBox();
    private final Label availQtyLbl = new Label();
    private final Label amountQtyLbl = new Label();
    private final TextField amountQtyTxt = new TextField();
    private final Label priceLbl = new Label();
    private final TextField priceTxt = new TextField();
    private final StackPane priceHintStack = new StackPane();
    private final Label limitPriceHint = new Label();
    private final Label stopPriceHint = new Label();
    private final ButtonType reviewBtnType = new ButtonType(DriveWealthBundle.getString("Review_order"), ButtonBar.ButtonData.OK_DONE);
    private final ButtonType cancelBtnType = new ButtonType(DriveWealthBundle.getString("Cancel"), ButtonBar.ButtonData.CANCEL_CLOSE);
    private ScheduledService<MarketData> marketDataSrv;
    private final SimpleDoubleProperty bidAskPrice = new SimpleDoubleProperty();
    private final SimpleDoubleProperty stopPriceBarrier = new SimpleDoubleProperty();
    private final SimpleStringProperty limitHintPty = new SimpleStringProperty();
    private final SimpleStringProperty stopHintPty = new SimpleStringProperty();
    private static final PseudoClass upLabel = PseudoClass.getPseudoClass((String)"up-label-color");
    private static final PseudoClass downLabel = PseudoClass.getPseudoClass((String)"down-label-color");

    public CreateOrderDlg(OpenPosition pos, OrderManager.OrderSide side) {
        this.side = side;
        this.symbol = pos.getSymbol();
        this.instrumentID = pos.getInstrumentID();
        this.openQty = pos.getOpenQty();
        this.name = pos.getName();
        this.urlImage = pos.getUrlImage();
    }

    public CreateOrderDlg(Instrument ins, OrderManager.OrderSide side) {
        this.side = side;
        this.symbol = ins.symbol;
        this.name = ins.name;
        this.instrumentID = ins.instrumentID;
        this.urlImage = ins.urlImage;
        this.openQty = 0.0;
    }

    private String stockName() {
        String stockName = this.symbol;
        if (this.name != null && !this.name.isEmpty()) {
            stockName = stockName + " - " + this.name;
        }
        return stockName;
    }

    public String openQtyStr() {
        return Utils.formatNumberNoComma(this.openQty, 4);
    }

    public void initDlgAndWait() {
        this.initDlgUI();
        this.reviewBtnBinding();
        this.startInstrumentTaskIfNeeded();
        this.resultConverter();
        this.startMarketDataSrv();
        Optional result = this.newOrdDlg.showAndWait();
        this.marketDataSrv.cancel();
        if (!result.isPresent()) {
            return;
        }
        Map data = (Map)result.get();
        this.showReviewOrdDlg(data);
    }

    private void priceHintBinding() {
        String stopStr;
        String limitStr;
        if (this.side == OrderManager.OrderSide.BUY) {
            limitStr = DriveWealthBundle.getString("Enter_limit_price") + " <= %s";
            this.stopPriceBarrier.bind((ObservableValue)this.bidAskPrice.add(0.05));
            stopStr = DriveWealthBundle.getString("Enter_stop_price") + " > %.2f";
        } else {
            limitStr = DriveWealthBundle.getString("Enter_limit_price") + " >= %s";
            this.stopPriceBarrier.bind((ObservableValue)this.bidAskPrice.subtract(0.05));
            stopStr = DriveWealthBundle.getString("Enter_stop_price") + " < %.2f";
        }
        this.limitHintPty.bind((ObservableValue)Bindings.format((String)limitStr, (Object[])new Object[]{this.bidAskPrice.asString()}));
        this.stopHintPty.bind((ObservableValue)Bindings.format((String)stopStr, (Object[])new Object[]{this.stopPriceBarrier}));
    }

    private void reviewBtnBinding() {
        BooleanBinding amountQtyValid = Bindings.createBooleanBinding(() -> {
            String qtyTxt = this.amountQtyTxt.getText().trim();
            if (!Utils.validateNumber(qtyTxt)) {
                return false;
            }
            if (this.side == OrderManager.OrderSide.BUY) {
                return true;
            }
            if (this.amountQtyChoice.getValue() == AmountQty.QTY) {
                return Double.parseDouble(qtyTxt) <= this.openQty;
            }
            return true;
        }, (Observable[])new Observable[]{this.amountQtyTxt.textProperty()});
        BooleanBinding priceValid = Bindings.createBooleanBinding(() -> {
            if (this.bidAskPrice.get() <= 0.0) {
                return false;
            }
            OrderManager.OrderType orderType = (OrderManager.OrderType)((Object)((Object)this.ordTypeChoice.getValue()));
            if (orderType == OrderManager.OrderType.MARKET) {
                return true;
            }
            String price = this.priceTxt.getText().trim();
            if (!Utils.validateNumber(price)) {
                return false;
            }
            if (orderType == OrderManager.OrderType.LIMIT) {
                return true;
            }
            if (this.side == OrderManager.OrderSide.BUY && Double.parseDouble(price) > this.stopPriceBarrier.get() || this.side == OrderManager.OrderSide.SELL && Double.parseDouble(price) < this.stopPriceBarrier.get()) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.priceTxt.textProperty(), this.ordTypeChoice.valueProperty(), this.stopPriceBarrier, this.bidAskPrice});
        Node reviewButton = this.newOrdDlg.getDialogPane().lookupButton(this.reviewBtnType);
        reviewButton.disableProperty().bind((ObservableValue)amountQtyValid.and((ObservableBooleanValue)priceValid).not());
    }

    private void initDlgUI() {
        String buySellOrder;
        String title;
        if (this.side == OrderManager.OrderSide.BUY) {
            title = DriveWealthBundle.getString("Buy");
            buySellOrder = DriveWealthBundle.getString("Buy_order");
        } else {
            title = DriveWealthBundle.getString("Sell");
            buySellOrder = DriveWealthBundle.getString("Sell_order");
        }
        GUIUtils.setDlgTitleHeaderLogo(this.newOrdDlg, title, this.stockName(), this.urlImage);
        this.newOrdDlg.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{this.reviewBtnType, this.cancelBtnType});
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        ColumnConstraints col1 = new ColumnConstraints(150.0);
        ColumnConstraints col2 = new ColumnConstraints(250.0);
        grid.getColumnConstraints().add((Object)col1);
        grid.getColumnConstraints().add((Object)col2);
        this.symbolTxt.setText(this.symbol);
        this.symbolTxt.setEditable(false);
        grid.add((Node)new Label(DriveWealthBundle.getString("Stock") + " :"), 0, 0);
        grid.add((Node)this.symbolTxt, 1, 0);
        String bidAsk = this.side == OrderManager.OrderSide.BUY ? DriveWealthBundle.getString("Ask_price") : DriveWealthBundle.getString("Bid_price");
        grid.add((Node)new Label(bidAsk), 0, 1);
        this.bidAskLbl.textProperty().bind((ObservableValue)this.bidAskPrice.asString());
        grid.add((Node)this.bidAskLbl, 1, 1);
        this.ordTypeChoice.getItems().setAll((Object[])OrderManager.OrderType.values());
        grid.add((Node)new Label(buySellOrder), 0, 2);
        grid.add(this.ordTypeChoice, 1, 2);
        this.amountQtyChoiceLbl.setText(DriveWealthBundle.getString("Share_cash_type"));
        this.amountQtyChoice.getItems().setAll((Object[])AmountQty.values());
        grid.add((Node)this.amountQtyChoiceLbl, 0, 3);
        grid.add(this.amountQtyChoice, 1, 3);
        grid.add((Node)this.amountQtyLbl, 0, 4);
        grid.add((Node)this.amountQtyTxt, 1, 4);
        GUIUtils.numbersOnly(this.amountQtyTxt);
        if (this.side == OrderManager.OrderSide.SELL) {
            String availQty = MessageFormat.format(DriveWealthBundle.getString("Available_qty"), this.openQtyStr());
            this.availQtyLbl.setText(availQty);
            grid.add((Node)this.availQtyLbl, 2, 4);
        }
        grid.add((Node)this.priceLbl, 0, 5);
        grid.add((Node)this.priceTxt, 1, 5);
        GUIUtils.numbersOnly(this.priceTxt);
        this.priceHintBinding();
        this.limitPriceHint.textProperty().bind((ObservableValue)this.limitHintPty);
        this.limitPriceHint.setPrefWidth(col2.getPrefWidth());
        this.stopPriceHint.textProperty().bind((ObservableValue)this.stopHintPty);
        this.stopPriceHint.setPrefWidth(col2.getPrefWidth());
        this.priceHintStack.setAlignment(Pos.CENTER_LEFT);
        this.priceHintStack.getChildren().addAll((Object[])new Node[]{this.limitPriceHint, this.stopPriceHint});
        grid.add((Node)this.priceHintStack, 1, 6);
        this.newOrdDlg.getDialogPane().setContent((Node)grid);
        this.priceLbl.managedProperty().bind((ObservableValue)this.priceLbl.visibleProperty());
        this.priceTxt.managedProperty().bind((ObservableValue)this.priceTxt.visibleProperty());
        this.priceHintStack.managedProperty().bind((ObservableValue)this.priceHintStack.visibleProperty());
        this.ordTypeChoiceListener();
        this.amountQtyChoiceListener();
        this.retrieveOrderOption();
        Platform.runLater(() -> this.amountQtyTxt.requestFocus());
    }

    private void retrieveOrderOption() {
        AmountQty defaultAmtQty;
        JStockOptions jstockOptions = JStock.instance().getJStockOptions();
        JStockOptions.DriveWealthBuySellOption driveWealthBuySellOption = this.side == OrderManager.OrderSide.BUY ? jstockOptions.getDriveWealthBuyOption() : jstockOptions.getDriveWealthSellOption();
        OrderManager.OrderType defaultOrdType = driveWealthBuySellOption == null ? null : driveWealthBuySellOption.orderType;
        AmountQty amountQty = defaultAmtQty = driveWealthBuySellOption == null ? null : driveWealthBuySellOption.amountQty;
        if (defaultOrdType == null) {
            defaultOrdType = OrderManager.OrderType.MARKET;
            defaultAmtQty = AmountQty.AMOUNT;
        }
        if (defaultAmtQty == null) {
            defaultAmtQty = defaultOrdType == OrderManager.OrderType.MARKET ? AmountQty.AMOUNT : AmountQty.QTY;
        }
        this.ordTypeChoice.setValue((Object)defaultOrdType);
        this.amountQtyChoice.setValue((Object)defaultAmtQty);
    }

    private void saveOrderOption(OrderManager.OrderType ordType, AmountQty amtQty) {
        JStockOptions jstockOptions = JStock.instance().getJStockOptions();
        if (ordType != OrderManager.OrderType.MARKET) {
            amtQty = AmountQty.QTY;
        }
        if (this.side == OrderManager.OrderSide.BUY) {
            jstockOptions.setDriveWealthBuyOption(ordType, amtQty);
        } else {
            jstockOptions.setDriveWealthSellOption(ordType, amtQty);
        }
    }

    private void showHidePriceField(OrderManager.OrderType orderType) {
        boolean show = false;
        switch (orderType) {
            case MARKET: {
                show = false;
                this.priceTxt.clear();
                break;
            }
            case LIMIT: {
                show = true;
                this.priceLbl.setText(DriveWealthBundle.getString("Limit_price"));
                this.priceHintStack.getChildren().clear();
                this.priceHintStack.getChildren().add((Object)this.limitPriceHint);
                break;
            }
            case STOP: {
                show = true;
                this.priceLbl.setText(DriveWealthBundle.getString("Stop_price"));
                this.priceHintStack.getChildren().clear();
                this.priceHintStack.getChildren().add((Object)this.stopPriceHint);
            }
        }
        this.priceLbl.setVisible(show);
        this.priceTxt.setVisible(show);
        this.priceHintStack.setVisible(show);
        Window window = this.newOrdDlg.getDialogPane().getScene().getWindow();
        window.sizeToScene();
    }

    private void ordTypeChoiceListener() {
        this.ordTypeChoice.valueProperty().addListener((observable, oldVal, newVal) -> {
            switch (newVal) {
                case MARKET: {
                    this.amountQtyChoice.setValue((Object)AmountQty.AMOUNT);
                    this.amountQtyChoice.setDisable(false);
                    this.showHidePriceField(OrderManager.OrderType.MARKET);
                    break;
                }
                case LIMIT: {
                    this.amountQtyChoice.setValue((Object)AmountQty.QTY);
                    this.amountQtyChoice.setDisable(true);
                    this.showHidePriceField(OrderManager.OrderType.LIMIT);
                    break;
                }
                case STOP: {
                    this.amountQtyChoice.setValue((Object)AmountQty.QTY);
                    this.amountQtyChoice.setDisable(true);
                    this.showHidePriceField(OrderManager.OrderType.STOP);
                    break;
                }
            }
        });
    }

    private void amountQtyChoiceListener() {
        this.amountQtyChoice.valueProperty().addListener((observable, oldVal, newVal) -> {
            String amtQtyPrompt;
            String amtQty;
            if (newVal == null) {
                return;
            }
            if (newVal == AmountQty.AMOUNT) {
                amtQty = DriveWealthBundle.getString("Cash");
                amtQtyPrompt = DriveWealthBundle.getString("Dollar_amount");
            } else {
                amtQty = DriveWealthBundle.getString("Share");
                amtQtyPrompt = DriveWealthBundle.getString("Units");
            }
            this.amountQtyTxt.clear();
            this.amountQtyLbl.setText(amtQty);
            this.amountQtyTxt.setPromptText(amtQtyPrompt);
        });
    }

    private void startMarketDataSrv() {
        this.marketDataSrv = new ScheduledService<MarketData>(){

            protected Task<MarketData> createTask() {
                return new Task<MarketData>(){

                    protected MarketData call() {
                        ArrayList<String> symbols = new ArrayList<String>();
                        symbols.add(CreateOrderDlg.this.symbol);
                        Map<String, Object> result = MarketDataManager.getMarketDataAsText(symbols, false);
                        if (result == null || result.isEmpty()) {
                            return null;
                        }
                        List dataList = (List)result.get("data");
                        MarketDataManager.MarketState marketState = (MarketDataManager.MarketState)((Object)result.get("marketState"));
                        if (marketState == MarketDataManager.MarketState.OPEN) {
                            this.setPeriod(Duration.millis((double)500.0));
                        } else {
                            this.setPeriod(Duration.seconds((double)5.0));
                        }
                        MarketData marketData = null;
                        if (dataList != null && !dataList.isEmpty()) {
                            marketData = (MarketData)dataList.get(0);
                        }
                        return marketData;
                    }
                };
            }
        };
        this.marketDataSrv.setPeriod(Duration.millis((double)500.0));
        this.marketDataSrv.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent workerStateEvent) {
                MarketData result = (MarketData)workerStateEvent.getSource().getValue();
                if (result != null) {
                    Double price = CreateOrderDlg.this.side == OrderManager.OrderSide.BUY ? result.ask : result.bid;
                    Double oldPrice = CreateOrderDlg.this.bidAskPrice.get();
                    CreateOrderDlg.this.bidAskPrice.set(price.doubleValue());
                    if (Double.compare(oldPrice, 0.0) > 0) {
                        CreateOrderDlg.this.bidAskLbl.pseudoClassStateChanged(upLabel, false);
                        CreateOrderDlg.this.bidAskLbl.pseudoClassStateChanged(downLabel, false);
                        int diff = Double.compare(price, oldPrice);
                        if (diff != 0) {
                            PseudoClass pClass = diff > 0 ? upLabel : downLabel;
                            CreateOrderDlg.this.bidAskLbl.pseudoClassStateChanged(pClass, true);
                            PauseTransition agingTime = new PauseTransition(Duration.seconds((double)1.0));
                            agingTime.setOnFinished(event -> {
                                CreateOrderDlg.this.bidAskLbl.pseudoClassStateChanged(upLabel, false);
                                CreateOrderDlg.this.bidAskLbl.pseudoClassStateChanged(downLabel, false);
                            });
                            agingTime.play();
                        }
                    }
                }
            }
        });
        this.marketDataSrv.setOnFailed(ev -> log.error((Object)("Create Order - Market Data Service failed: " + ev.toString())));
        this.marketDataSrv.setOnCancelled(ev -> log.error((Object)("Create Order - Market Data Service cancelled: " + ev.toString())));
        this.marketDataSrv.start();
    }

    private void resultConverter() {
        this.newOrdDlg.setResultConverter(dlgBtn -> {
            if (dlgBtn == this.reviewBtnType) {
                this.ordType = (OrderManager.OrderType)((Object)((Object)this.ordTypeChoice.getValue()));
                Double price = this.ordType == OrderManager.OrderType.MARKET ? this.bidAskPrice.get() : Double.parseDouble(this.priceTxt.getText().trim());
                AmountQty amountQty = (AmountQty)((Object)((Object)this.amountQtyChoice.getValue()));
                Double qty = null;
                Double amount = null;
                if (this.ordType == OrderManager.OrderType.MARKET && amountQty == AmountQty.AMOUNT) {
                    amount = Double.parseDouble(this.amountQtyTxt.getText().trim());
                } else {
                    qty = Double.parseDouble(this.amountQtyTxt.getText().trim());
                }
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("orderType", (Object)this.ordType);
                result.put("amountQty", (Object)amountQty);
                result.put("qty", qty);
                result.put("cash", amount);
                result.put("price", price);
                return result;
            }
            return null;
        });
    }

    private void showReviewOrdDlg(Map<String, Object> data) {
        OrderManager.OrderType orderType = (OrderManager.OrderType)((Object)data.get("orderType"));
        AmountQty amountQty = (AmountQty)((Object)data.get("amountQty"));
        Double qty = (Double)data.get("qty");
        Double cash = (Double)data.get("cash");
        Double price = (Double)data.get("price");
        this.saveOrderOption(orderType, amountQty);
        this.reviewDlg = new Alert(Alert.AlertType.CONFIRMATION);
        GUIUtils.setDlgTitleHeaderLogo((Dialog)this.reviewDlg, DriveWealthBundle.getString("Review_order"), this.stockName(), this.urlImage);
        OrderSummary summary = OrderSummary.buildFromDialog(this.symbol, this.name, this.urlImage, this.instrumentID, amountQty, qty, cash, price, orderType, this.side);
        TableView orderTable = OrderSummary.OrdSummaryTable(summary);
        String footer = null;
        if (this.side == OrderManager.OrderSide.SELL) {
            footer = DriveWealthBundle.getString("SEC_TAF_excluded_in_commission");
        }
        GUIUtils.setDlgContent((Dialog)this.reviewDlg, (Node)orderTable, null, footer);
        ButtonType submitButtonType = new ButtonType(DriveWealthBundle.getString("Submit_order"), ButtonBar.ButtonData.OK_DONE);
        ButtonType cancelButtonType = new ButtonType(DriveWealthBundle.getString("Cancel"), ButtonBar.ButtonData.CANCEL_CLOSE);
        this.reviewDlg.getButtonTypes().setAll((Object[])new ButtonType[]{submitButtonType, cancelButtonType});
        this.submitOrderHandler(this.reviewDlg, submitButtonType);
        this.reviewDlg.show();
    }

    private void submitOrderHandler(final Alert reviewDlg, ButtonType submitButtonType) {
        Node submitButton = reviewDlg.getDialogPane().lookupButton(submitButtonType);
        submitButton.addEventFilter(ActionEvent.ACTION, event -> {
            Portfolio.getInstance().cancelService();
            event.consume();
            GUIUtils.dlgShowProgressIn((Dialog)reviewDlg);
            User user = SessionManager.getInstance().getUser();
            Account acc = user.getActiveAccount();
            String userID = user.userID;
            String accountID = acc.accountID;
            String accountNo = acc.accountNo;
            VBox vBox = (VBox)((StackPane)reviewDlg.getDialogPane().getContent()).getChildren().get(0);
            TableView ordTable = null;
            while (vBox.getChildren().iterator().hasNext()) {
                Node child = (Node)vBox.getChildren().iterator().next();
                if (!(child instanceof TableView)) continue;
                ordTable = (TableView)child;
                break;
            }
            final OrderSummary summary = (OrderSummary)ordTable.getItems().get(0);
            OrderManager.OrderType orderType = summary.ordType;
            final OrderManager.OrderSide ordSide = summary.ordSide;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("symbol", summary.getSymbol());
            params.put("instrumentID", summary.instrumentID);
            params.put("accountID", accountID);
            params.put("accountNo", accountNo);
            params.put("userID", userID);
            params.put("accountType", acc.accType.value);
            params.put("ordType", summary.ordType.value);
            params.put("side", ordSide.value);
            if (orderType != OrderManager.OrderType.MARKET || summary.amountQty == AmountQty.QTY) {
                Double qty = Utils.formattedNumtoDouble(summary.getQty());
                params.put("orderQty", qty);
            } else {
                Double subtotal = Utils.formattedNumtoDouble(summary.getSubtotal());
                params.put("amountCash", subtotal);
            }
            if (orderType == OrderManager.OrderType.LIMIT || orderType == OrderManager.OrderType.STOP) {
                String key = orderType == OrderManager.OrderType.STOP ? "price" : "limitPrice";
                Double price = Utils.formattedNumtoDouble(summary.getPrice());
                params.put(key, price);
            }
            Task task = BuySell.startThread(ordSide, orderType, params);
            task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

                public void handle(WorkerStateEvent workerStateEvent) {
                    log.info((Object)(ordSide.value + " Task Succeed Handler"));
                    Pair result = (Pair)workerStateEvent.getSource().getValue();
                    Order order = (Order)result.first;
                    String error = (String)result.second;
                    if (error != null) {
                        CreateOrderDlg.this.showFailedDlg(error);
                        return;
                    }
                    CreateOrderDlg.this.resultDlg = new Alert(Alert.AlertType.INFORMATION);
                    String header = "";
                    OrderManager.OrdStatus ordStatus = order.ordStatusEnum;
                    log.info((Object)("Order Status: " + ordStatus.value));
                    switch (ordStatus) {
                        case REJECTED: {
                            header = DriveWealthBundle.getString("Order_rejected");
                            CreateOrderDlg.this.resultDlg.setContentText(MessageFormat.format(DriveWealthBundle.getString("Rejected_reason"), order.ordRejReason));
                            break;
                        }
                        case FILLED: {
                            header = DriveWealthBundle.getString("Order_was_filled_email_notification");
                            OrderSummary ordSummary = OrderSummary.buildFromOrder(summary, order);
                            TableView resultTable = OrderSummary.OrdSummaryTable(ordSummary);
                            GUIUtils.setDlgContent((Dialog)CreateOrderDlg.this.resultDlg, (Node)resultTable, null, null);
                            break;
                        }
                        case NEW: 
                        case PARTIAL_FILLED: {
                            String expiryTime;
                            String expiryUTC;
                            header = DriveWealthBundle.getString("Order_was_entered_view_pending_orders");
                            TableView resultTable = OrderSummary.OrdSummaryTable(summary);
                            String headerNote = DriveWealthBundle.getString("Estimated_order_values");
                            String footerNote = null;
                            if (OrderManager.OrderType.LIMIT.value == Integer.parseInt(order.ordType) && (expiryUTC = order.isoTimeRestingOrderExpires) != null && (expiryTime = Utils.utcToLocalAndEst(expiryUTC)) != null) {
                                footerNote = MessageFormat.format(DriveWealthBundle.getString("Order_expires_on"), expiryTime);
                            }
                            GUIUtils.setDlgContent((Dialog)CreateOrderDlg.this.resultDlg, (Node)resultTable, headerNote, footerNote);
                            break;
                        }
                    }
                    reviewDlg.close();
                    GUIUtils.setDlgTitleHeaderLogo((Dialog)CreateOrderDlg.this.resultDlg, DriveWealthBundle.getString("Order_status"), header, summary.logoURL);
                    CreateOrderDlg.this.resultDlg.setOnCloseRequest(event -> {
                        log.info((Object)"resultDlg OnCloseRequest - restart Portfolio");
                        Portfolio.getInstance().restartService();
                    });
                    CreateOrderDlg.this.resultDlg.show();
                }
            });
            task.setOnCancelled(ev -> {
                log.warn((Object)"buySellTask is cancelled");
                this.showFailedDlg(null);
            });
            task.setOnFailed(ev -> {
                log.warn((Object)"buySellTask has failed");
                this.showFailedDlg(null);
            });
        });
    }

    private void showFailedDlg(String error) {
        this.reviewDlg.close();
        String title = this.side == OrderManager.OrderSide.BUY ? DriveWealthBundle.getString("Buy_order_error") : DriveWealthBundle.getString("Sell_order_error");
        String errMsg = error != null ? error : ApiError.commonMsg();
        this.resultDlg = GUIUtils.alertDlg(Alert.AlertType.ERROR, title, this.stockName(), errMsg);
        GUIUtils.setDlgGraphic((Dialog)this.resultDlg, this.urlImage);
        this.resultDlg.setOnCloseRequest(event -> {
            log.info((Object)"Create Order failed Dlg OnCloseRequest - restart Portfolio");
            Portfolio.getInstance().restartService();
        });
        this.resultDlg.show();
    }

    public void startInstrumentTaskIfNeeded() {
        if (this.name == null || this.name.isEmpty()) {
            Task<Instrument> task = GUIUtils.startInstrumentTask(this.symbol);
            task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

                public void handle(WorkerStateEvent workerStateEvent) {
                    Instrument ins = (Instrument)workerStateEvent.getSource().getValue();
                    CreateOrderDlg.this.name = ins.name;
                    CreateOrderDlg.this.urlImage = ins.urlImage;
                    if (CreateOrderDlg.this.newOrdDlg.isShowing()) {
                        CreateOrderDlg.this.newOrdDlg.setHeaderText(CreateOrderDlg.this.symbol + " - " + CreateOrderDlg.this.name);
                        GUIUtils.setDlgGraphic(CreateOrderDlg.this.newOrdDlg, CreateOrderDlg.this.urlImage);
                    }
                    if (CreateOrderDlg.this.reviewDlg != null && CreateOrderDlg.this.reviewDlg.isShowing()) {
                        CreateOrderDlg.this.reviewDlg.setHeaderText(CreateOrderDlg.this.symbol + " - " + CreateOrderDlg.this.name);
                        GUIUtils.setDlgGraphic((Dialog)CreateOrderDlg.this.reviewDlg, CreateOrderDlg.this.urlImage);
                    }
                    if (CreateOrderDlg.this.resultDlg != null && CreateOrderDlg.this.resultDlg.isShowing()) {
                        GUIUtils.setDlgGraphic((Dialog)CreateOrderDlg.this.resultDlg, CreateOrderDlg.this.urlImage);
                    }
                }
            });
            task.setOnFailed(ev -> log.error((Object)("Create Order Dialog - Get Instrument Task failed: " + ev.toString())));
            task.setOnCancelled(ev -> log.error((Object)("Create Order Dialog - Get Instrument Task cancelled: " + ev.toString())));
        }
    }

    public static enum AmountQty {
        AMOUNT("Cash_type"),
        QTY("Share_type");

        private final String key;

        private AmountQty(String key) {
            this.key = key;
        }

        public String toString() {
            return DriveWealthBundle.getString(this.key);
        }
    }
}

