/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.analysis;

import java.math.BigDecimal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.analysis.AbstractOperator;

public class FunctionOperator
extends AbstractOperator {
    private Function function = Function.Absolute;
    private static final Log log = LogFactory.getLog(FunctionOperator.class);

    @Override
    protected Object calculate() {
        Double result = null;
        switch (this.function) {
            case Absolute: {
                result = this.absolute();
                break;
            }
            case Square: {
                result = this.square();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return result;
    }

    private Double absolute() {
        Object object0 = this.inputs[0].getValue();
        try {
            BigDecimal d0 = new BigDecimal(object0.toString());
            return d0.abs().doubleValue();
        }
        catch (NumberFormatException exp) {
            log.error(null, (Throwable)exp);
            return null;
        }
    }

    private Double square() {
        Object object0 = this.inputs[0].getValue();
        try {
            BigDecimal d0 = new BigDecimal(object0.toString());
            return d0.pow(2).doubleValue();
        }
        catch (NumberFormatException exp) {
            log.error(null, (Throwable)exp);
            return null;
        }
    }

    public void setFunction(Function function) {
        Function old = this.function;
        this.function = function;
        if (old != this.function) {
            this.firePropertyChange("attribute", (Object)old, (Object)this.function);
        }
    }

    public Function getFunction() {
        return this.function;
    }

    @Override
    public int getNumOfInputConnector() {
        return 1;
    }

    @Override
    public Class getInputClass(int index) {
        return Double.class;
    }

    @Override
    public Class getOutputClass(int index) {
        return Double.class;
    }

    public static enum Function {
        Absolute,
        Square;

    }
}

