/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.utilities;

import cz.vity.freerapid.utilities.LogUtils;
import java.util.logging.Logger;
import org.java.plugin.registry.PluginAttribute;
import org.java.plugin.registry.PluginDescriptor;

public final class DescriptorUtils {
    private static final Logger logger = Logger.getLogger(DescriptorUtils.class.getName());

    private DescriptorUtils() {
    }

    public static String getAttribute(String name, String defaultValue, PluginDescriptor descriptor) {
        PluginAttribute attribute = descriptor.getAttribute(name);
        if (attribute == null) {
            return defaultValue;
        }
        return attribute.getValue();
    }

    public static boolean getAttribute(String name, boolean defaultValue, PluginDescriptor descriptor) {
        PluginAttribute attribute = descriptor.getAttribute(name);
        if (attribute == null) {
            return defaultValue;
        }
        return "true".equalsIgnoreCase(attribute.getValue());
    }

    public static int getAttribute(String name, int defaultValue, PluginDescriptor descriptor) {
        PluginAttribute attribute = descriptor.getAttribute(name);
        if (attribute == null) {
            return defaultValue;
        }
        String value = attribute.getValue();
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            LogUtils.processException(logger, e);
            return defaultValue;
        }
    }
}

