/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.value.Trigger;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import cz.vity.freerapid.core.application.SubmitErrorInfo;
import cz.vity.freerapid.core.tasks.SubmitErrorInfoTask;
import cz.vity.freerapid.gui.dialogs.AppDialog;
import cz.vity.freerapid.gui.dialogs.ConnectDialog;
import cz.vity.freerapid.swing.ComponentFactory;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.jdesktop.application.Action;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskEvent;
import org.jdesktop.application.TaskListener;

public class SubmitErrorDialog
extends AppDialog {
    private static final Logger logger = Logger.getLogger(SubmitErrorDialog.class.getName());
    private final SubmitErrorInfo errorInfo;
    private PresentationModel<SubmitErrorInfo> model = null;
    private JTextField fieldName;
    private JTextField fieldEmail;
    private JTextArea commentTextArea;
    private JButton btnConnection;
    private JButton btnOk;
    private JButton btnCancel;

    public SubmitErrorDialog(JFrame owner, SubmitErrorInfo errorInfo) {
        super((Frame)owner, true);
        this.errorInfo = errorInfo;
        this.setName("SubmitErrorDialog");
        try {
            this.initComponents();
            this.build();
        }
        catch (Exception e) {
            LogUtils.processException(logger, e);
            this.doClose();
        }
    }

    @Override
    protected AbstractButton getBtnOK() {
        return this.btnOk;
    }

    @Override
    protected AbstractButton getBtnCancel() {
        return this.btnCancel;
    }

    @Action
    public void cancelBtnAction() {
        this.model.triggerFlush();
        this.doClose();
    }

    @Action
    public void btnConnectionAction() {
        ConnectDialog connectDialog = new ConnectDialog(this);
        this.getApp().prepareDialog(connectDialog, true);
    }

    @Action(block=Task.BlockingScope.APPLICATION)
    public Task<Void, Void> okBtnAction() {
        this.setResult(0);
        this.model.triggerCommit();
        this.setVisible(false);
        SubmitErrorInfoTask errorInfoTask = new SubmitErrorInfoTask(this.errorInfo);
        errorInfoTask.addTaskListener(new TaskListener.Adapter<Void, Void>(){

            @Override
            public void failed(TaskEvent<Throwable> event) {
                SubmitErrorDialog.this.showCheckYourConnection(event.getValue());
                SubmitErrorDialog.this.setVisible(true);
            }

            @Override
            public void succeeded(TaskEvent<Void> event) {
                Swinger.showInformationDialog(SubmitErrorDialog.this.getResourceMap().getString("infomessage_submit_succeed", new Object[0]));
                SubmitErrorDialog.this.doClose();
            }
        });
        return errorInfoTask;
    }

    private void showCheckYourConnection(Throwable value) {
        if (value instanceof UnknownHostException) {
            Swinger.showErrorMessage(this.getResourceMap(), "errormessage_check_inet_settings", new Object[0]);
        } else {
            Swinger.showErrorMessage(this.getResourceMap(), "errormessage_submit_failed", value.getLocalizedMessage());
        }
    }

    @Override
    public void doClose() {
        if (this.model != null) {
            this.model.release();
        }
        super.doClose();
    }

    private void build() {
        this.inject();
        this.buildGUI();
        this.setAction(this.btnOk, "okBtnAction");
        this.setAction(this.btnCancel, "cancelBtnAction");
        this.setAction(this.btnConnection, "btnConnectionAction");
        this.pack();
        this.setResizable(true);
        SubmitErrorDialog.locateOnOpticalScreenCenter(this);
    }

    private void buildGUI() {
        this.model = new PresentationModel<SubmitErrorInfo>(this.errorInfo, (ValueModel)new Trigger());
        Bindings.bind(this.fieldName, (ValueModel)this.model.getBufferedModel("name"));
        Bindings.bind(this.fieldEmail, (ValueModel)this.model.getBufferedModel("email"));
        Bindings.bind(this.commentTextArea, (ValueModel)this.model.getBufferedModel("comment"));
    }

    private void initComponents() {
        JPanel dialogPane = new JPanel();
        JPanel contentPanel = new JPanel();
        JLabel labelName = new JLabel();
        this.fieldName = ComponentFactory.getTextField();
        JLabel labelEmail = new JLabel();
        this.fieldEmail = ComponentFactory.getTextField();
        JLabel labelComment = new JLabel();
        JScrollPane scrollPane1 = new JScrollPane();
        this.commentTextArea = ComponentFactory.getTextArea();
        JLabel labelDescribeInfo = new JLabel();
        JPanel buttonBar = new JPanel();
        this.btnConnection = new JButton();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        CellConstraints cc = new CellConstraints();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        dialogPane.setBorder(Borders.DIALOG);
        dialogPane.setName("dialogPane");
        dialogPane.setLayout(new BorderLayout());
        contentPanel.setName("contentPanel");
        labelName.setLabelFor(this.fieldName);
        labelName.setName("labelName");
        this.fieldName.setColumns(15);
        this.fieldName.setName("fieldName");
        labelEmail.setLabelFor(this.fieldEmail);
        labelEmail.setName("labelEmail");
        this.fieldEmail.setColumns(15);
        this.fieldEmail.setName("fieldEmail");
        labelComment.setLabelFor(this.commentTextArea);
        labelComment.setName("labelComment");
        scrollPane1.setName("scrollPane1");
        this.commentTextArea.setRows(10);
        this.commentTextArea.setLineWrap(true);
        this.commentTextArea.setName("commentTextArea");
        scrollPane1.setViewportView(this.commentTextArea);
        labelDescribeInfo.setName("labelDescribeInfo");
        PanelBuilder contentPanelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, Sizes.DEFAULT, 1.0), FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}), contentPanel);
        contentPanelBuilder.add((Component)labelName, cc.xy(1, 1));
        contentPanelBuilder.add((Component)this.fieldName, cc.xy(3, 1));
        contentPanelBuilder.add((Component)labelEmail, cc.xy(5, 1));
        contentPanelBuilder.add((Component)this.fieldEmail, cc.xy(7, 1));
        contentPanelBuilder.add((Component)labelComment, cc.xywh(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.TOP));
        contentPanelBuilder.add((Component)scrollPane1, cc.xywh(3, 3, 5, 1));
        contentPanelBuilder.add((Component)labelDescribeInfo, cc.xywh(3, 5, 5, 1));
        dialogPane.add((Component)contentPanel, "Center");
        buttonBar.setBorder(Borders.BUTTON_BAR_PAD);
        buttonBar.setName("buttonBar");
        this.btnConnection.setName("btnConnection");
        this.btnOk.setName("okButton");
        this.btnCancel.setName("cancelButton");
        PanelBuilder buttonBarBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode("max(min;10dlu):grow"), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.BUTTON_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ComponentFactory.BUTTON_COLSPEC}, RowSpec.decodeSpecs("pref")), buttonBar);
        buttonBarBuilder.add((Component)this.btnConnection, cc.xywh(2, 1, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT));
        buttonBarBuilder.add((Component)this.btnOk, cc.xy(6, 1));
        buttonBarBuilder.add((Component)this.btnCancel, cc.xy(8, 1));
        dialogPane.add((Component)buttonBar, "South");
        contentPane.add((Component)dialogPane, "Center");
    }
}

