/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import cz.vity.freerapid.swing.SwingUtils;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class CompoundUndoManager
extends UndoManager
implements UndoableEditListener {
    public CompoundEdit compoundEdit;
    private JTextComponent editor;
    private int lastOffset;

    public CompoundUndoManager(JTextComponent editor) {
        this.editor = editor;
        editor.getDocument().addUndoableEditListener(this);
        editor.getActionMap().put("undo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CompoundUndoManager.this.canUndo()) {
                    CompoundUndoManager.this.undo();
                }
            }
        });
        editor.getActionMap().put("redo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CompoundUndoManager.this.canRedo()) {
                    CompoundUndoManager.this.redo();
                }
            }
        });
        editor.getInputMap().put(SwingUtils.getCtrlKeyStroke(90), "undo");
        editor.getInputMap().put(SwingUtils.getCtrlShiftKeyStroke(90), "redo");
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        if (this.compoundEdit == null) {
            this.compoundEdit = this.startCompoundEdit(e.getEdit());
            return;
        }
        AbstractDocument.DefaultDocumentEvent event = (AbstractDocument.DefaultDocumentEvent)e.getEdit();
        int diff = this.editor.getCaretPosition() - this.lastOffset;
        if (Math.abs(diff) == 1 || event.getType().equals(DocumentEvent.EventType.CHANGE)) {
            this.compoundEdit.addEdit(e.getEdit());
            this.lastOffset += diff;
            return;
        }
        this.compoundEdit.end();
        this.compoundEdit = this.startCompoundEdit(e.getEdit());
    }

    private CompoundEdit startCompoundEdit(UndoableEdit anEdit) {
        this.lastOffset = this.editor.getCaretPosition();
        this.compoundEdit = new MyCompoundEdit();
        this.compoundEdit.addEdit(anEdit);
        this.addEdit(this.compoundEdit);
        return this.compoundEdit;
    }

    class MyCompoundEdit
    extends CompoundEdit {
        MyCompoundEdit() {
        }

        @Override
        public boolean isInProgress() {
            return false;
        }

        @Override
        public void undo() throws CannotUndoException {
            if (CompoundUndoManager.this.compoundEdit != null) {
                CompoundUndoManager.this.compoundEdit.end();
            }
            super.undo();
            CompoundUndoManager.this.compoundEdit = null;
        }
    }
}

