/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.content;

import cz.vity.freerapid.core.tasks.DownloadTask;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpDownloadClient;
import java.awt.Component;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;

final class ConnectionCellRenderer
extends DefaultTableCellRenderer {
    private final String defaultConnection;
    private static final Logger logger = Logger.getLogger(ConnectionCellRenderer.class.getName());

    ConnectionCellRenderer(ApplicationContext context) {
        ResourceMap map = context.getResourceMap();
        this.defaultConnection = map.getString("defaultConnection", new Object[0]);
    }

    @Override
    public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        HttpDownloadClient client;
        if (value == null) {
            value = table.getValueAt(row, column);
        }
        DownloadFile downloadFile = (DownloadFile)value;
        DownloadTask task = downloadFile.getTask();
        ConnectionSettings con = null;
        if (downloadFile.getState() == DownloadState.SLEEPING || downloadFile.getState() == DownloadState.ERROR) {
            con = downloadFile.getConnectionSettings();
        }
        if (con == null && task != null && (client = task.getClient()) != null) {
            con = client.getSettings();
        }
        if (con != null) {
            if (con.isProxySet()) {
                value = String.format("%s:%s", con.getProxyURL(), con.getProxyPort());
                if (con.getUserName() != null) {
                    value = con.getUserName() + "@" + value;
                }
            } else {
                value = this.defaultConnection;
            }
        } else {
            value = "";
        }
        this.getAccessibleContext().setAccessibleDescription(table.getColumnName(column) + " " + value.toString());
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }
}

