/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsTheme;
import com.pagosoft.plaf.themes.ElegantGrayTheme;
import com.pagosoft.plaf.themes.SilverTheme;
import com.pagosoft.plaf.themes.VistaTheme;
import com.pagosoft.swing.ColorUtils;
import java.awt.Color;
import java.awt.Insets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

public class ThemeFactory {
    public static final PgsTheme GRAY = ThemeFactory.createTheme("Gray", new Color(7968721), new Color(0xABABAB), Color.black);
    public static final PgsTheme YELLOW = ThemeFactory.createTheme("Yellow", new Color(13412947), new Color(0xABABAB), Color.black);
    public static final PgsTheme RUBY = ThemeFactory.createTheme("Ruby", new Color(244, 10, 66), new Color(0xABABAB), Color.black);
    public static final PgsTheme GOLD = ThemeFactory.createTheme("Gold", new Color(16767785));
    public static final PgsTheme WIN = new PgsTheme("Win", new Color(6324396), new Color(16764721), new Color(16375945), new Color(0x666554), new Color(0xDCDBCB), new Color(15855843), Color.black, Color.white, ThemeFactory.getWinCustomEntries());
    public static final PgsTheme GREEN = ThemeFactory.createTheme("Green", new Color(9988167), new Color(15723495), Color.BLACK);
    private static final Pattern SPLIT = Pattern.compile("\\s*,?\\s*");

    private static Object[] getWinCustomEntries() {
        Color s2 = new Color(0xDCDBCB);
        Color s3 = new Color(15855843);
        Color p2 = new Color(16375945);
        Color p3 = new Color(16764721);
        return new Object[]{"Button.rolloverGradientStart", Color.white, "Button.rolloverGradientEnd", s2, "Button.selectedGradientStart", p3, "Button.selectedGradientEnd", p2, "ToggleButton.rolloverGradientStart", Color.white, "ToggleButton.rolloverGradientEnd", s2, "ToggleButton.selectedGradientStart", p3, "ToggleButton.selectedGradientEnd", p2, "ToolBar.gradientStart", s3, "ToolBar.gradientEnd", s2, "ToolBarButton.rolloverGradientStart", p3, "ToolBarButton.rolloverGradientEnd", p2, "ToolBarButton.selectedGradientStart", p2, "ToolBarButton.selectedGradientEnd", p3, "ScrollBar.thumb", p3, "ScrollBar.thumbHighlight", p3.brighter(), "ProgressBar.gradientStart", p3, "ProgressBar.gradientEnd", p3.brighter()};
    }

    public static PgsTheme createTheme(Color primary) {
        return ThemeFactory.createTheme("PgsTheme", primary);
    }

    public static PgsTheme createTheme(String name, Color primary) {
        Color[] cs = ColorUtils.mixColors(primary);
        return new PgsTheme(name, cs[2], cs[1], cs[0], cs[5], cs[4], cs[3], cs[8], cs[7]);
    }

    public static PgsTheme createTheme(Color primary, Color secondary, Color text) {
        return ThemeFactory.createTheme("Custom PgsTheme", primary, secondary, text);
    }

    public static PgsTheme getDefaultTheme() {
        return new SilverTheme();
    }

    public static PgsTheme createTheme(String name, Color primary, Color secondary, Color text) {
        return new PgsTheme(name, primary.darker(), primary, primary.brighter(), secondary.darker(), secondary, secondary.brighter(), text, ColorUtils.oposite(text));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PgsTheme getTheme(String theme) {
        if (theme == null) {
            throw new IllegalArgumentException("theme must not be null!");
        }
        if (theme.startsWith("theme:")) {
            String name = theme.substring(5).trim();
            return ThemeFactory.getThemeByName(name);
        }
        if (theme.startsWith("colors:")) {
            String colors = theme.substring(6).trim();
            return ThemeFactory.getThemeByColors(colors);
        }
        if (theme.startsWith("res:")) {
            String res = theme.substring(4).trim();
            File f = new File(res);
            if (f.exists()) {
                Properties props = new Properties();
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(f);
                    props.load(fis);
                    fis.close();
                    PgsTheme pgsTheme = ThemeFactory.createTheme(props);
                    return pgsTheme;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    PgsTheme pgsTheme = ThemeFactory.getDefaultTheme();
                    return pgsTheme;
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            return ThemeFactory.getDefaultTheme();
        }
        if (theme.length() > 0) {
            return ThemeFactory.getThemeByName(theme);
        }
        return ThemeFactory.getDefaultTheme();
    }

    public static PgsTheme getThemeByName(String theme) {
        if ("ruby".equals(theme = theme.toLowerCase())) {
            return RUBY;
        }
        if ("win".equals(theme)) {
            return WIN;
        }
        if ("yellow".equals(theme)) {
            return YELLOW;
        }
        if ("gold".equals(theme)) {
            return GOLD;
        }
        if ("gray".equals(theme)) {
            return GRAY;
        }
        if ("green".equals(theme)) {
            return GREEN;
        }
        if ("elegantgray".equals(theme)) {
            return ElegantGrayTheme.getInstance();
        }
        if ("silver".equals(theme)) {
            return new SilverTheme();
        }
        if ("vista".equals(theme)) {
            return new VistaTheme();
        }
        try {
            Class<?> cls = Class.forName(theme);
            if (PgsTheme.class.isAssignableFrom(cls)) {
                return (PgsTheme)cls.newInstance();
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return ThemeFactory.getDefaultTheme();
    }

    public static PgsTheme getThemeByColors(String colors) {
        String[] color = colors.split(",?\\s*");
        if (color.length != 2) {
            throw new IllegalArgumentException("Theme has the wrong format: '" + colors + "', but should be '[primary], [secondary], [text]'");
        }
        return ThemeFactory.createTheme(Color.decode(color[0]), Color.decode(color[1]), Color.decode(color[2]));
    }

    public static PgsTheme createTheme(Map map) {
        ArrayList<Object> data = new ArrayList<Object>();
        Iterator i = map.keySet().iterator();
        String name = "Custom PgsTheme";
        Color p1 = null;
        Color p2 = null;
        Color p3 = null;
        Color s1 = null;
        Color s2 = null;
        Color s3 = null;
        Color bl = Color.black;
        Color wh = Color.white;
        while (i.hasNext()) {
            String key = i.next().toString();
            String value = map.get(key).toString();
            if (key.equals("name")) {
                name = value;
                continue;
            }
            if (key.equals("primary1")) {
                p1 = Color.decode(value);
                continue;
            }
            if (key.equals("primary2")) {
                p2 = Color.decode(value);
                continue;
            }
            if (key.equals("primary3")) {
                p3 = Color.decode(value);
                continue;
            }
            if (key.equals("secondary1")) {
                s1 = Color.decode(value);
                continue;
            }
            if (key.equals("secondary2")) {
                s2 = Color.decode(value);
                continue;
            }
            if (key.equals("secondary3")) {
                s3 = Color.decode(value);
                continue;
            }
            if (key.equals("black")) {
                bl = Color.decode(value);
                continue;
            }
            if (key.equals("white")) {
                wh = Color.decode(value);
                continue;
            }
            if (key.startsWith("pgs.") || key.startsWith("swing.")) continue;
            data.add(key);
            if (value.startsWith("#")) {
                data.add(Color.decode(value));
                continue;
            }
            if (value.equals("true")) {
                data.add(Boolean.TRUE);
                continue;
            }
            if (value.equals("false")) {
                data.add(Boolean.FALSE);
                continue;
            }
            String[] val = SPLIT.split(value);
            switch (val.length) {
                case 1: {
                    int in = Integer.parseInt(val[0]);
                    data.add(new Insets(in, in, in, in));
                    break;
                }
                case 2: {
                    int in1 = Integer.parseInt(val[0]);
                    int in2 = Integer.parseInt(val[1]);
                    data.add(new Insets(in1, in2, in1, in2));
                    break;
                }
                case 4: {
                    data.add(new Insets(Integer.parseInt(val[0]), Integer.parseInt(val[1]), Integer.parseInt(val[2]), Integer.parseInt(val[3])));
                }
            }
        }
        if (p1 != null && p2 != null && p3 != null && s1 != null && s2 != null && s3 != null) {
            return new PgsTheme(name, p1, p2, p3, s1, s2, s3, bl, wh, data.toArray());
        }
        return ThemeFactory.getDefaultTheme();
    }
}

