/*
 * Decompiled with CFR 0.152.
 */
package javax.persistence.spi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolver;

public class PersistenceProviderResolverHolder {
    private static PersistenceProviderResolver singleton = new DefaultPersistenceProviderResolver();

    public static PersistenceProviderResolver getPersistenceProviderResolver() {
        return singleton;
    }

    public static void setPersistenceProviderResolver(PersistenceProviderResolver persistenceProviderResolver) {
        singleton = persistenceProviderResolver == null ? new DefaultPersistenceProviderResolver() : persistenceProviderResolver;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultPersistenceProviderResolver
    implements PersistenceProviderResolver {
        private volatile HashMap<CacheKey, PersistenceProviderReference> providers = new HashMap();
        private static final ReferenceQueue referenceQueue = new ReferenceQueue();
        private static final String LOGGER_SUBSYSTEM = "javax.persistence.spi";
        private Logger logger;
        private static final String SERVICE_PROVIDER_FILE = "META-INF/services/javax.persistence.spi.PersistenceProvider";
        private static final Pattern nonCommentPattern = Pattern.compile("^([^#]+)");

        private DefaultPersistenceProviderResolver() {
        }

        @Override
        public List<PersistenceProvider> getPersistenceProviders() {
            this.processQueue();
            ClassLoader classLoader = DefaultPersistenceProviderResolver.getContextClassLoader();
            CacheKey cacheKey = new CacheKey(classLoader);
            PersistenceProviderReference persistenceProviderReference = this.providers.get(cacheKey);
            ArrayList<PersistenceProvider> arrayList = null;
            if (persistenceProviderReference != null) {
                arrayList = (ArrayList<PersistenceProvider>)persistenceProviderReference.get();
            }
            if (arrayList == null) {
                Collection<ProviderName> collection = this.getProviderNames(classLoader);
                arrayList = new ArrayList<PersistenceProvider>();
                for (ProviderName providerName : collection) {
                    try {
                        PersistenceProvider persistenceProvider = (PersistenceProvider)classLoader.loadClass(providerName.getName()).newInstance();
                        arrayList.add(persistenceProvider);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.log(Level.FINEST, classNotFoundException + ": " + providerName);
                    }
                    catch (InstantiationException instantiationException) {
                        this.log(Level.FINEST, instantiationException + ": " + providerName);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        this.log(Level.FINEST, illegalAccessException + ": " + providerName);
                    }
                    catch (ClassCastException classCastException) {
                        this.log(Level.FINEST, classCastException + ": " + providerName);
                    }
                }
                if (arrayList.isEmpty() && !collection.isEmpty()) {
                    this.log(Level.WARNING, "No valid providers found using:");
                    for (ProviderName providerName : collection) {
                        this.log(Level.WARNING, providerName.toString());
                    }
                }
                persistenceProviderReference = new PersistenceProviderReference(arrayList, referenceQueue, cacheKey);
                this.providers.put(cacheKey, persistenceProviderReference);
            }
            return arrayList;
        }

        private void processQueue() {
            CacheKeyReference cacheKeyReference;
            while ((cacheKeyReference = (CacheKeyReference)((Object)referenceQueue.poll())) != null) {
                this.providers.remove(cacheKeyReference.getCacheKey());
            }
        }

        private static ClassLoader getContextClassLoader() {
            if (System.getSecurityManager() == null) {
                return Thread.currentThread().getContextClassLoader();
            }
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }

        private void log(Level level, String string) {
            if (this.logger == null) {
                this.logger = Logger.getLogger(LOGGER_SUBSYSTEM);
            }
            this.logger.log(level, "javax.persistence.spi::" + string);
        }

        private Collection<ProviderName> getProviderNames(ClassLoader classLoader) {
            Enumeration<URL> enumeration = null;
            try {
                enumeration = classLoader.getResources(SERVICE_PROVIDER_FILE);
            }
            catch (IOException iOException) {
                throw new PersistenceException("IOException caught: " + classLoader + ".getResources(" + SERVICE_PROVIDER_FILE + ")", iOException);
            }
            ArrayList<ProviderName> arrayList = new ArrayList<ProviderName>();
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                this.addProviderNames(uRL, arrayList);
            }
            return arrayList;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void addProviderNames(URL uRL, Collection<ProviderName> collection) {
            InputStream inputStream = null;
            try {
                try {
                    String string;
                    inputStream = uRL.openStream();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    while ((string = bufferedReader.readLine()) != null) {
                        Matcher matcher = nonCommentPattern.matcher(string = string.trim());
                        if (!matcher.find()) continue;
                        collection.add(new ProviderName(matcher.group().trim(), uRL));
                    }
                    Object var8_8 = null;
                    if (inputStream == null) return;
                }
                catch (IOException iOException) {
                    throw new PersistenceException("IOException caught reading: " + uRL, iOException);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            inputStream.close();
            return;
        }

        @Override
        public void clearCachedProviders() {
            this.providers.clear();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class PersistenceProviderReference
        extends SoftReference<List<PersistenceProvider>>
        implements CacheKeyReference {
            private CacheKey cacheKey;

            PersistenceProviderReference(List<PersistenceProvider> list, ReferenceQueue referenceQueue, CacheKey cacheKey) {
                super(list, referenceQueue);
                this.cacheKey = cacheKey;
            }

            @Override
            public CacheKey getCacheKey() {
                return this.cacheKey;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class LoaderReference
        extends WeakReference<ClassLoader>
        implements CacheKeyReference {
            private CacheKey cacheKey;

            LoaderReference(ClassLoader classLoader, ReferenceQueue referenceQueue, CacheKey cacheKey) {
                super(classLoader, referenceQueue);
                this.cacheKey = cacheKey;
            }

            @Override
            public CacheKey getCacheKey() {
                return this.cacheKey;
            }
        }

        private class CacheKey
        implements Cloneable {
            private LoaderReference loaderRef;
            private int hashCodeCache;

            CacheKey(ClassLoader classLoader) {
                this.loaderRef = classLoader == null ? null : new LoaderReference(classLoader, referenceQueue, this);
                this.calculateHashCode();
            }

            ClassLoader getLoader() {
                return this.loaderRef != null ? (ClassLoader)this.loaderRef.get() : null;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                try {
                    CacheKey cacheKey = (CacheKey)object;
                    if (this.hashCodeCache != cacheKey.hashCodeCache) {
                        return false;
                    }
                    if (this.loaderRef == null) {
                        return cacheKey.loaderRef == null;
                    }
                    ClassLoader classLoader = (ClassLoader)this.loaderRef.get();
                    return cacheKey.loaderRef != null && classLoader != null && classLoader == cacheKey.loaderRef.get();
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                return false;
            }

            public int hashCode() {
                return this.hashCodeCache;
            }

            private void calculateHashCode() {
                ClassLoader classLoader = this.getLoader();
                if (classLoader != null) {
                    this.hashCodeCache = classLoader.hashCode();
                }
            }

            public Object clone() {
                try {
                    CacheKey cacheKey = (CacheKey)super.clone();
                    if (this.loaderRef != null) {
                        cacheKey.loaderRef = new LoaderReference((ClassLoader)this.loaderRef.get(), referenceQueue, cacheKey);
                    }
                    return cacheKey;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new InternalError();
                }
            }

            public String toString() {
                return "CacheKey[" + this.getLoader() + ")]";
            }
        }

        private static interface CacheKeyReference {
            public CacheKey getCacheKey();
        }

        private class ProviderName {
            private String name;
            private URL source;

            public ProviderName(String string, URL uRL) {
                this.name = string;
                this.source = uRL;
            }

            public String getName() {
                return this.name;
            }

            public URL getSource() {
                return this.source;
            }

            public String toString() {
                return this.getName() + " - " + this.getSource();
            }
        }
    }
}

