/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Dimension;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.plaf.metal.MetalFileChooserUI;

public class BaseFileChooserUI
extends MetalFileChooserUI {
    private FileView fileView = new BaseFileView();
    private static int PREF_WIDTH = 580;
    private static int PREF_HEIGHT = 340;
    private static Dimension PREF_SIZE = new Dimension(PREF_WIDTH, PREF_HEIGHT);

    public BaseFileChooserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BaseFileChooserUI((JFileChooser)jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        int n = BaseFileChooserUI.PREF_SIZE.width;
        Dimension dimension = jComponent.getLayout().preferredLayoutSize(jComponent);
        if (dimension != null) {
            return new Dimension(dimension.width < n ? n : dimension.width, dimension.height < BaseFileChooserUI.PREF_SIZE.height ? BaseFileChooserUI.PREF_SIZE.height : dimension.height);
        }
        return new Dimension(n, BaseFileChooserUI.PREF_SIZE.height);
    }

    public FileView getFileView(JFileChooser jFileChooser) {
        if (JTattooUtilities.getJavaVersion() < 1.4) {
            return super.getFileView(jFileChooser);
        }
        return this.fileView;
    }

    protected class BaseFileView
    extends BasicFileChooserUI.BasicFileView {
        protected BaseFileView() {
            super(BaseFileChooserUI.this);
        }

        public Icon getIcon(File file) {
            Icon icon = this.getCachedIcon(file);
            if (icon != null) {
                return icon;
            }
            if (file != null) {
                icon = BaseFileChooserUI.this.getFileChooser().getFileSystemView().getSystemIcon(file);
            }
            if (icon == null) {
                icon = super.getIcon(file);
            }
            this.cacheIcon(file, icon);
            return icon;
        }
    }
}

