/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.file;

import java.nio.channels.FileChannel;
import org.apache.mina.core.file.FileRegion;

public class DefaultFileRegion
implements FileRegion {
    private final FileChannel channel;
    private final long originalPosition;
    private long position;
    private long remainingBytes;

    public DefaultFileRegion(FileChannel fileChannel, long l, long l2) {
        if (fileChannel == null) {
            throw new IllegalArgumentException("channel can not be null");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("position may not be less than 0");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("remainingBytes may not be less than 0");
        }
        this.channel = fileChannel;
        this.originalPosition = l;
        this.position = l;
        this.remainingBytes = l2;
    }

    public long getRemainingBytes() {
        return this.remainingBytes;
    }

    public FileChannel getFileChannel() {
        return this.channel;
    }

    public long getPosition() {
        return this.position;
    }

    public void update(long l) {
        this.position += l;
        this.remainingBytes -= l;
    }
}

