/*
 * Decompiled with CFR 0.152.
 */
package davmail;

import davmail.BundleMessage;
import davmail.ui.tray.DavGatewayTray;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;

public final class Settings {
    public static final String O365_URL = "https://outlook.office365.com/EWS/Exchange.asmx";
    public static final String O365 = "O365";
    public static final String O365_MODERN = "O365Modern";
    public static final String O365_INTERACTIVE = "O365Interactive";
    public static final String O365_MANUAL = "O365Manual";
    public static final String WEBDAV = "WebDav";
    public static final String EWS = "EWS";
    public static final String AUTO = "Auto";
    private static final Properties SETTINGS = new Properties(){

        @Override
        public synchronized Enumeration<Object> keys() {
            Enumeration<Object> keysEnumeration = super.keys();
            TreeSet<String> sortedKeySet = new TreeSet<String>();
            while (keysEnumeration.hasMoreElements()) {
                sortedKeySet.add((String)keysEnumeration.nextElement());
            }
            final Iterator sortedKeysIterator = sortedKeySet.iterator();
            return new Enumeration<Object>(){

                @Override
                public boolean hasMoreElements() {
                    return sortedKeysIterator.hasNext();
                }

                @Override
                public Object nextElement() {
                    return sortedKeysIterator.next();
                }
            };
        }
    };
    private static String configFilePath;
    private static boolean isFirstStart;

    private Settings() {
    }

    public static synchronized void setConfigFilePath(String path) {
        configFilePath = path;
    }

    public static synchronized boolean isFirstStart() {
        return isFirstStart;
    }

    public static synchronized void load(InputStream inputStream) throws IOException {
        SETTINGS.load(inputStream);
        Settings.updateLoggingConfig();
    }

    public static synchronized void load() {
        FileInputStream fileInputStream = null;
        try {
            File configFile;
            if (configFilePath == null) {
                configFilePath = System.getProperty("user.home") + "/.davmail.properties";
            }
            if ((configFile = new File(configFilePath)).exists()) {
                fileInputStream = new FileInputStream(configFile);
                Settings.load(fileInputStream);
            } else {
                isFirstStart = true;
                Settings.setDefaultSettings();
                Settings.save();
            }
        }
        catch (IOException e) {
            DavGatewayTray.error(new BundleMessage("LOG_UNABLE_TO_LOAD_SETTINGS", new Object[0]), e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    DavGatewayTray.debug(new BundleMessage("LOG_ERROR_CLOSING_CONFIG_FILE", new Object[0]), e);
                }
            }
        }
        Settings.updateLoggingConfig();
    }

    public static void setDefaultSettings() {
        SETTINGS.put("davmail.mode", EWS);
        SETTINGS.put("davmail.url", O365_URL);
        SETTINGS.put("davmail.popPort", "1110");
        SETTINGS.put("davmail.imapPort", "1143");
        SETTINGS.put("davmail.smtpPort", "1025");
        SETTINGS.put("davmail.caldavPort", "1080");
        SETTINGS.put("davmail.ldapPort", "1389");
        SETTINGS.put("davmail.clientSoTimeout", "");
        SETTINGS.put("davmail.keepDelay", "30");
        SETTINGS.put("davmail.sentKeepDelay", "0");
        SETTINGS.put("davmail.caldavPastDelay", "0");
        SETTINGS.put("davmail.caldavAutoSchedule", Boolean.TRUE.toString());
        SETTINGS.put("davmail.imapIdleDelay", "");
        SETTINGS.put("davmail.folderSizeLimit", "");
        SETTINGS.put("davmail.enableKeepAlive", Boolean.FALSE.toString());
        SETTINGS.put("davmail.allowRemote", Boolean.FALSE.toString());
        SETTINGS.put("davmail.bindAddress", "");
        SETTINGS.put("davmail.useSystemProxies", Boolean.FALSE.toString());
        SETTINGS.put("davmail.enableProxy", Boolean.FALSE.toString());
        SETTINGS.put("davmail.enableKerberos", "false");
        SETTINGS.put("davmail.disableUpdateCheck", "false");
        SETTINGS.put("davmail.proxyHost", "");
        SETTINGS.put("davmail.proxyPort", "");
        SETTINGS.put("davmail.proxyUser", "");
        SETTINGS.put("davmail.proxyPassword", "");
        SETTINGS.put("davmail.noProxyFor", "");
        SETTINGS.put("davmail.server", Boolean.FALSE.toString());
        SETTINGS.put("davmail.server.certificate.hash", "");
        SETTINGS.put("davmail.caldavAlarmSound", "");
        SETTINGS.put("davmail.carddavReadPhoto", Boolean.TRUE.toString());
        SETTINGS.put("davmail.forceActiveSyncUpdate", Boolean.FALSE.toString());
        SETTINGS.put("davmail.showStartupBanner", Boolean.TRUE.toString());
        SETTINGS.put("davmail.disableGuiNotifications", Boolean.FALSE.toString());
        SETTINGS.put("davmail.disableTrayActivitySwitch", Boolean.FALSE.toString());
        SETTINGS.put("davmail.imapAutoExpunge", Boolean.TRUE.toString());
        SETTINGS.put("davmail.imapAlwaysApproxMsgSize", Boolean.FALSE.toString());
        SETTINGS.put("davmail.popMarkReadOnRetr", Boolean.FALSE.toString());
        SETTINGS.put("davmail.smtpSaveInSent", Boolean.TRUE.toString());
        SETTINGS.put("davmail.ssl.keystoreType", "");
        SETTINGS.put("davmail.ssl.keystoreFile", "");
        SETTINGS.put("davmail.ssl.keystorePass", "");
        SETTINGS.put("davmail.ssl.keyPass", "");
        SETTINGS.put("davmail.ssl.clientKeystoreType", "");
        SETTINGS.put("davmail.ssl.clientKeystoreFile", "");
        SETTINGS.put("davmail.ssl.clientKeystorePass", "");
        SETTINGS.put("davmail.ssl.pkcs11Library", "");
        SETTINGS.put("davmail.ssl.pkcs11Config", "");
        SETTINGS.put("davmail.ssl.nosecurepop", Boolean.FALSE.toString());
        SETTINGS.put("davmail.ssl.nosecureimap", Boolean.FALSE.toString());
        SETTINGS.put("davmail.ssl.nosecuresmtp", Boolean.FALSE.toString());
        SETTINGS.put("davmail.ssl.nosecurecaldav", Boolean.FALSE.toString());
        SETTINGS.put("davmail.ssl.nosecureldap", Boolean.FALSE.toString());
        SETTINGS.put("log4j.rootLogger", Level.WARN.toString());
        SETTINGS.put("log4j.logger.davmail", Level.DEBUG.toString());
        SETTINGS.put("log4j.logger.httpclient.wire", Level.WARN.toString());
        SETTINGS.put("log4j.logger.org.apache.commons.httpclient", Level.WARN.toString());
        SETTINGS.put("davmail.logFilePath", "");
    }

    public static String getLogFilePath() {
        String logFilePath = Settings.getProperty("davmail.logFilePath");
        if (logFilePath == null || logFilePath.length() == 0) {
            logFilePath = Settings.getBooleanProperty("davmail.server") ? "davmail.log" : (System.getProperty("os.name").toLowerCase().startsWith("mac os x") ? System.getProperty("user.home") + "/Library/Logs/DavMail/davmail.log" : System.getProperty("user.home") + "/davmail.log");
        } else {
            File logFile = new File(logFilePath);
            if (logFile.isDirectory()) {
                logFilePath = logFilePath + "/davmail.log";
            }
        }
        return logFilePath;
    }

    public static String getLogFileDirectory() {
        String logFilePath = Settings.getLogFilePath();
        if (logFilePath == null || logFilePath.length() == 0) {
            return ".";
        }
        int lastSlashIndex = logFilePath.lastIndexOf(47);
        if (lastSlashIndex == -1) {
            lastSlashIndex = logFilePath.lastIndexOf(92);
        }
        if (lastSlashIndex >= 0) {
            return logFilePath.substring(0, lastSlashIndex);
        }
        return ".";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateLoggingConfig() {
        String logFilePath = Settings.getLogFilePath();
        try {
            Object logFile;
            if (logFilePath != null && logFilePath.length() > 0) {
                logFile = new File(logFilePath);
                File logFileDir = ((File)logFile).getParentFile();
                if (logFileDir != null && !logFileDir.exists() && !logFileDir.mkdirs()) {
                    DavGatewayTray.error(new BundleMessage("LOG_UNABLE_TO_CREATE_LOG_FILE_DIR", new Object[0]));
                    throw new IOException();
                }
            } else {
                logFilePath = "davmail.log";
            }
            logFile = Logger.getRootLogger();
            synchronized (logFile) {
                FileAppender fileAppender = (FileAppender)Logger.getRootLogger().getAppender("FileAppender");
                if (fileAppender == null) {
                    String logFileSize = Settings.getProperty("davmail.logFileSize");
                    if (logFileSize == null || logFileSize.length() == 0) {
                        logFileSize = "1MB";
                    }
                    if ("0".equals(logFileSize)) {
                        fileAppender = new FileAppender();
                    } else {
                        fileAppender = new RollingFileAppender();
                        ((RollingFileAppender)fileAppender).setMaxBackupIndex(2);
                        ((RollingFileAppender)fileAppender).setMaxFileSize(logFileSize);
                    }
                    fileAppender.setName("FileAppender");
                    fileAppender.setEncoding("UTF-8");
                    fileAppender.setLayout((Layout)new PatternLayout("%d{ISO8601} %-5p [%t] %c %x - %m%n"));
                }
                fileAppender.setFile(logFilePath, true, false, 8192);
                Logger.getRootLogger().addAppender((Appender)fileAppender);
            }
            ConsoleAppender consoleAppender = (ConsoleAppender)Logger.getRootLogger().getAppender("ConsoleAppender");
            if (consoleAppender != null) {
                if (Settings.getBooleanProperty("davmail.server")) {
                    consoleAppender.setThreshold((Priority)Level.ALL);
                } else {
                    consoleAppender.setThreshold((Priority)Level.OFF);
                }
            }
        }
        catch (IOException e) {
            DavGatewayTray.error(new BundleMessage("LOG_UNABLE_TO_SET_LOG_FILE_PATH", new Object[0]));
        }
        Settings.setLoggingLevel("rootLogger", Settings.getLoggingLevel("rootLogger"));
        Settings.setLoggingLevel("davmail", Settings.getLoggingLevel("davmail"));
        Settings.setLoggingLevel("httpclient.wire", Settings.getLoggingLevel("httpclient.wire"));
        Settings.setLoggingLevel("org.apache.commons.httpclient", Settings.getLoggingLevel("org.apache.commons.httpclient"));
        Settings.setLoggingLevel("org.apache.http.wire", Settings.getLoggingLevel("httpclient.wire"));
        Settings.setLoggingLevel("org.apache.http", Settings.getLoggingLevel("org.apache.commons.httpclient"));
    }

    public static synchronized void save() {
        if (configFilePath != null) {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)SETTINGS);
            ArrayList<String> lines = new ArrayList<String>();
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configFilePath), StandardCharsets.ISO_8859_1));){
                Settings.readLines(lines, properties);
                for (String value : lines) {
                    writer.write(value);
                    writer.newLine();
                }
                Enumeration<?> propertyEnumeration = properties.propertyNames();
                while (propertyEnumeration.hasMoreElements()) {
                    String propertyName = (String)propertyEnumeration.nextElement();
                    writer.write(propertyName + "=" + Settings.escapeValue(properties.getProperty(propertyName)));
                    writer.newLine();
                }
            }
            catch (IOException e) {
                DavGatewayTray.error(new BundleMessage("LOG_UNABLE_TO_STORE_SETTINGS", new Object[0]), e);
            }
        }
        Settings.updateLoggingConfig();
    }

    private static void readLines(ArrayList<String> lines, Properties properties) {
        block15: {
            try {
                File configFile = new File(configFilePath);
                if (!configFile.exists()) break block15;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.ISO_8859_1));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        lines.add(Settings.convertLine(line, properties));
                    }
                }
            }
            catch (IOException e) {
                DavGatewayTray.error(new BundleMessage("LOG_UNABLE_TO_LOAD_SETTINGS", new Object[0]), e);
            }
        }
    }

    private static String convertLine(String line, Properties properties) {
        String key;
        String value;
        int index;
        String comment = "";
        int hashIndex = line.indexOf(35);
        if (hashIndex >= 0) {
            comment = line.substring(hashIndex);
            line = line.substring(0, hashIndex);
        }
        if ((index = line.indexOf(61)) >= 0 && (value = properties.getProperty(key = line.substring(0, index))) != null) {
            line = key + "=" + Settings.escapeValue(value);
            properties.remove(key);
        }
        return line + comment;
    }

    private static String escapeValue(String value) {
        StringBuilder buffer = new StringBuilder();
        for (char c : value.toCharArray()) {
            if (c == '\\') {
                buffer.append('\\');
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static synchronized String getProperty(String property) {
        String value = SETTINGS.getProperty(property);
        if (value != null && value.length() == 0) {
            value = null;
        }
        return value;
    }

    public static synchronized String getProperty(String property, String defaultValue) {
        String value = Settings.getProperty(property);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static synchronized char[] getCharArrayProperty(String property) {
        String propertyValue = Settings.getProperty(property);
        char[] value = null;
        if (propertyValue != null) {
            value = propertyValue.toCharArray();
        }
        return value;
    }

    public static synchronized void setProperty(String property, String value) {
        if (value != null) {
            SETTINGS.setProperty(property, value);
        } else {
            SETTINGS.setProperty(property, "");
        }
    }

    public static synchronized int getIntProperty(String property) {
        return Settings.getIntProperty(property, 0);
    }

    public static synchronized int getIntProperty(String property, int defaultValue) {
        int value = defaultValue;
        try {
            String propertyValue = SETTINGS.getProperty(property);
            if (propertyValue != null && propertyValue.length() > 0) {
                value = Integer.parseInt(propertyValue);
            }
        }
        catch (NumberFormatException e) {
            DavGatewayTray.error(new BundleMessage("LOG_INVALID_SETTING_VALUE", property), e);
        }
        return value;
    }

    public static synchronized boolean getBooleanProperty(String property) {
        String propertyValue = SETTINGS.getProperty(property);
        return Boolean.parseBoolean(propertyValue);
    }

    public static synchronized boolean getBooleanProperty(String property, boolean defaultValue) {
        boolean value = defaultValue;
        String propertyValue = SETTINGS.getProperty(property);
        if (propertyValue != null && propertyValue.length() > 0) {
            value = Boolean.parseBoolean(propertyValue);
        }
        return value;
    }

    public static synchronized String loadRefreshToken(String username) {
        return Settings.getProperty("davmail.oauth." + username.toLowerCase() + ".refreshToken");
    }

    public static synchronized void storeRefreshToken(String refreshToken, String username) {
        Settings.setProperty("davmail.oauth." + username.toLowerCase() + ".refreshToken", refreshToken);
        Settings.save();
    }

    private static String getLoggingPrefix(String category) {
        String prefix = "rootLogger".equals(category) ? "log4j." : "log4j.logger.";
        return prefix;
    }

    public static synchronized Level getLoggingLevel(String category) {
        String prefix = Settings.getLoggingPrefix(category);
        String currentValue = SETTINGS.getProperty(prefix + category);
        if (currentValue != null && currentValue.length() > 0) {
            return Level.toLevel((String)currentValue);
        }
        if ("rootLogger".equals(category)) {
            return Logger.getRootLogger().getLevel();
        }
        return Logger.getLogger((String)category).getLevel();
    }

    public static synchronized Properties getSubProperties(String scope) {
        String keyStart = scope == null || scope.length() == 0 ? "" : (scope.endsWith(".") ? scope : scope + '.');
        Properties result = new Properties();
        for (Map.Entry<Object, Object> entry : SETTINGS.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(keyStart)) continue;
            String value = (String)entry.getValue();
            result.setProperty(key.substring(keyStart.length()), value);
        }
        return result;
    }

    public static synchronized void setLoggingLevel(String category, Level level) {
        if (level != null) {
            String prefix = Settings.getLoggingPrefix(category);
            SETTINGS.setProperty(prefix + category, level.toString());
            if ("rootLogger".equals(category)) {
                Logger.getRootLogger().setLevel(level);
            } else {
                Logger.getLogger((String)category).setLevel(level);
            }
        }
    }

    public static synchronized void saveProperty(String property, String value) {
        Settings.load();
        Settings.setProperty(property, value);
        Settings.save();
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().startsWith("linux");
    }

    public static boolean isUnix() {
        return Settings.isLinux() || System.getProperty("os.name").toLowerCase().startsWith("freebsd");
    }
}

