/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.timeout.impl;

import java.time.Duration;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.gradle.internal.concurrent.ManagedScheduledExecutor;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.execution.timeout.Timeout;
import org.gradle.internal.execution.timeout.TimeoutHandler;

public class DefaultTimeoutHandler
implements TimeoutHandler,
Stoppable {
    private final ManagedScheduledExecutor executor;

    public DefaultTimeoutHandler(ManagedScheduledExecutor executor) {
        this.executor = executor;
    }

    @Override
    public Timeout start(Thread taskExecutionThread, Duration timeout) {
        InterruptOnTimeout interrupter = new InterruptOnTimeout(taskExecutionThread);
        ScheduledFuture timeoutTask = this.executor.schedule((Runnable)interrupter, timeout.toMillis(), TimeUnit.MILLISECONDS);
        return new DefaultTimeout(timeoutTask, interrupter);
    }

    @Override
    public void stop() {
        this.executor.stop();
    }

    private static class InterruptOnTimeout
    implements Runnable {
        private final Thread thread;
        private volatile boolean interrupted;

        private InterruptOnTimeout(Thread thread) {
            this.thread = thread;
        }

        @Override
        public void run() {
            this.interrupted = true;
            this.thread.interrupt();
        }
    }

    private static final class DefaultTimeout
    implements Timeout {
        private final ScheduledFuture<?> timeoutTask;
        private final InterruptOnTimeout interrupter;

        private DefaultTimeout(ScheduledFuture<?> timeoutTask, InterruptOnTimeout interrupter) {
            this.timeoutTask = timeoutTask;
            this.interrupter = interrupter;
        }

        @Override
        public boolean stop() {
            this.timeoutTask.cancel(true);
            return this.interrupter.interrupted;
        }
    }
}

