/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.work.AbstractConditionalExecution;
import org.gradle.internal.work.AsyncWorkCompletion;
import org.gradle.internal.work.AsyncWorkTracker;
import org.gradle.internal.work.ConditionalExecution;
import org.gradle.internal.work.ConditionalExecutionQueue;
import org.gradle.internal.work.NoAvailableWorkerLeaseException;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.JavaForkOptionsFactory;
import org.gradle.process.internal.JavaForkOptionsInternal;
import org.gradle.process.internal.worker.child.WorkerDirectoryProvider;
import org.gradle.util.CollectionUtils;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.WorkerConfiguration;
import org.gradle.workers.WorkerExecutionException;
import org.gradle.workers.WorkerExecutor;
import org.gradle.workers.internal.ActionExecutionSpec;
import org.gradle.workers.internal.BuildOperationAwareWorker;
import org.gradle.workers.internal.ClassLoaderStructureProvider;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DaemonForkOptionsBuilder;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.DefaultWorkerConfiguration;
import org.gradle.workers.internal.KeepAliveMode;
import org.gradle.workers.internal.SerializedParametersActionExecutionSpec;
import org.gradle.workers.internal.WorkerExecutionQueueFactory;
import org.gradle.workers.internal.WorkerFactory;

public class DefaultWorkerExecutor
implements WorkerExecutor {
    private final ConditionalExecutionQueue<DefaultWorkResult> executionQueue;
    private final WorkerFactory daemonWorkerFactory;
    private final WorkerFactory isolatedClassloaderWorkerFactory;
    private final WorkerFactory noIsolationWorkerFactory;
    private final JavaForkOptionsFactory forkOptionsFactory;
    private final WorkerLeaseRegistry workerLeaseRegistry;
    private final BuildOperationExecutor buildOperationExecutor;
    private final AsyncWorkTracker asyncWorkTracker;
    private final WorkerDirectoryProvider workerDirectoryProvider;
    private final ClassLoaderStructureProvider classLoaderStructureProvider;

    public DefaultWorkerExecutor(WorkerFactory daemonWorkerFactory, WorkerFactory isolatedClassloaderWorkerFactory, WorkerFactory noIsolationWorkerFactory, JavaForkOptionsFactory forkOptionsFactory, WorkerLeaseRegistry workerLeaseRegistry, BuildOperationExecutor buildOperationExecutor, AsyncWorkTracker asyncWorkTracker, WorkerDirectoryProvider workerDirectoryProvider, WorkerExecutionQueueFactory workerExecutionQueueFactory, ClassLoaderStructureProvider classLoaderStructureProvider) {
        this.daemonWorkerFactory = daemonWorkerFactory;
        this.isolatedClassloaderWorkerFactory = isolatedClassloaderWorkerFactory;
        this.noIsolationWorkerFactory = noIsolationWorkerFactory;
        this.forkOptionsFactory = forkOptionsFactory;
        this.executionQueue = workerExecutionQueueFactory.create();
        this.workerLeaseRegistry = workerLeaseRegistry;
        this.buildOperationExecutor = buildOperationExecutor;
        this.asyncWorkTracker = asyncWorkTracker;
        this.workerDirectoryProvider = workerDirectoryProvider;
        this.classLoaderStructureProvider = classLoaderStructureProvider;
    }

    @Override
    public void submit(Class<? extends Runnable> actionClass, Action<? super WorkerConfiguration> configAction) {
        SerializedParametersActionExecutionSpec spec;
        String description;
        DefaultWorkerConfiguration configuration = new DefaultWorkerConfiguration(this.forkOptionsFactory);
        File workingDirectory = this.workerDirectoryProvider.getWorkingDirectory();
        configuration.getForkOptions().setWorkingDir(workingDirectory);
        configAction.execute((Object)configuration);
        String string = description = configuration.getDisplayName() != null ? configuration.getDisplayName() : actionClass.getName();
        if (!workingDirectory.equals(configuration.getForkOptions().getWorkingDir())) {
            throw new WorkExecutionException(description + ": setting the working directory of a worker is not supported.");
        }
        DaemonForkOptions forkOptions = this.getDaemonForkOptions(actionClass, configuration);
        try {
            spec = new SerializedParametersActionExecutionSpec(actionClass, description, configuration.getParams(), forkOptions.getClassLoaderStructure());
        }
        catch (Throwable t) {
            throw new WorkExecutionException(description, t);
        }
        this.submit(spec, configuration.getIsolationMode(), forkOptions);
    }

    private void submit(final ActionExecutionSpec spec, final IsolationMode isolationMode, final DaemonForkOptions daemonForkOptions) {
        WorkerLeaseRegistry.WorkerLease currentWorkerWorkerLease = this.getCurrentWorkerLease();
        final BuildOperationRef currentBuildOperation = this.buildOperationExecutor.getCurrentOperation();
        WorkerExecution execution = new WorkerExecution(spec.getDisplayName(), currentWorkerWorkerLease, new Callable<DefaultWorkResult>(){

            @Override
            public DefaultWorkResult call() throws Exception {
                try {
                    WorkerFactory workerFactory = DefaultWorkerExecutor.this.getWorkerFactory(isolationMode);
                    BuildOperationAwareWorker worker = workerFactory.getWorker(daemonForkOptions);
                    return worker.execute(spec, currentBuildOperation);
                }
                catch (Throwable t) {
                    throw new WorkExecutionException(spec.getDisplayName(), t);
                }
            }
        });
        this.executionQueue.submit((ConditionalExecution)execution);
        this.asyncWorkTracker.registerWork(currentBuildOperation, (AsyncWorkCompletion)execution);
    }

    private WorkerLeaseRegistry.WorkerLease getCurrentWorkerLease() {
        try {
            return this.workerLeaseRegistry.getCurrentWorkerLease();
        }
        catch (NoAvailableWorkerLeaseException e) {
            throw new IllegalStateException("An attempt was made to submit work from a thread not managed by Gradle.  Work may only be submitted from a Gradle-managed thread.", e);
        }
    }

    private WorkerFactory getWorkerFactory(IsolationMode isolationMode) {
        switch (isolationMode) {
            case AUTO: 
            case CLASSLOADER: {
                return this.isolatedClassloaderWorkerFactory;
            }
            case NONE: {
                return this.noIsolationWorkerFactory;
            }
            case PROCESS: {
                return this.daemonWorkerFactory;
            }
        }
        throw new IllegalArgumentException("Unknown isolation mode: " + (Object)((Object)isolationMode));
    }

    @Override
    public void await() throws WorkerExecutionException {
        BuildOperationRef currentOperation = this.buildOperationExecutor.getCurrentOperation();
        try {
            if (this.asyncWorkTracker.hasUncompletedWork(currentOperation)) {
                this.executionQueue.expand();
            }
            this.asyncWorkTracker.waitForCompletion(currentOperation, false);
        }
        catch (DefaultMultiCauseException e) {
            throw this.workerExecutionException(e.getCauses());
        }
    }

    private WorkerExecutionException workerExecutionException(List<? extends Throwable> failures) {
        if (failures.size() == 1) {
            throw new WorkerExecutionException("There was a failure while executing work items", failures);
        }
        throw new WorkerExecutionException("There were multiple failures while executing work items", failures);
    }

    DaemonForkOptions getDaemonForkOptions(Class<?> actionClass, WorkerConfiguration configuration) {
        this.validateWorkerConfiguration(configuration);
        List paramTypes = CollectionUtils.collect((Object[])configuration.getParams(), (Transformer)new Transformer<Class<?>, Object>(){

            public Class<?> transform(Object o) {
                return o.getClass();
            }
        });
        return this.toDaemonOptions(actionClass, paramTypes, configuration.getForkOptions(), configuration.getClasspath(), configuration.getIsolationMode());
    }

    private void validateWorkerConfiguration(WorkerConfiguration configuration) {
        if (configuration.getIsolationMode() == IsolationMode.NONE && configuration.getClasspath().iterator().hasNext()) {
            throw this.unsupportedWorkerConfigurationException("classpath", configuration.getIsolationMode());
        }
        if (configuration.getIsolationMode() == IsolationMode.NONE || configuration.getIsolationMode() == IsolationMode.CLASSLOADER) {
            if (!configuration.getForkOptions().getBootstrapClasspath().isEmpty()) {
                throw this.unsupportedWorkerConfigurationException("bootstrap classpath", configuration.getIsolationMode());
            }
            if (!configuration.getForkOptions().getJvmArgs().isEmpty()) {
                throw this.unsupportedWorkerConfigurationException("jvm arguments", configuration.getIsolationMode());
            }
            if (configuration.getForkOptions().getMaxHeapSize() != null) {
                throw this.unsupportedWorkerConfigurationException("maximum heap size", configuration.getIsolationMode());
            }
            if (configuration.getForkOptions().getMinHeapSize() != null) {
                throw this.unsupportedWorkerConfigurationException("minimum heap size", configuration.getIsolationMode());
            }
            if (!configuration.getForkOptions().getSystemProperties().isEmpty()) {
                throw this.unsupportedWorkerConfigurationException("system properties", configuration.getIsolationMode());
            }
        }
    }

    private RuntimeException unsupportedWorkerConfigurationException(String propertyDescription, IsolationMode isolationMode) {
        return new UnsupportedOperationException("The worker " + propertyDescription + " cannot be set when using isolation mode " + isolationMode.name());
    }

    private DaemonForkOptions toDaemonOptions(Class<?> actionClass, Iterable<Class<?>> paramClasses, JavaForkOptions userForkOptions, Iterable<File> classpath, IsolationMode isolationMode) {
        JavaForkOptionsInternal forkOptions = this.forkOptionsFactory.newJavaForkOptions();
        userForkOptions.copyTo((JavaForkOptions)forkOptions);
        forkOptions.setWorkingDir(this.workerDirectoryProvider.getWorkingDirectory());
        DaemonForkOptionsBuilder builder = new DaemonForkOptionsBuilder(this.forkOptionsFactory).javaForkOptions((JavaForkOptions)forkOptions).keepAliveMode(KeepAliveMode.DAEMON);
        if (isolationMode != IsolationMode.NONE) {
            ImmutableSet.Builder classpathBuilder = ImmutableSet.builder();
            if (classpath != null) {
                classpathBuilder.addAll(classpath);
            }
            DefaultWorkerExecutor.addVisibilityFor(actionClass, (ImmutableSet.Builder<File>)classpathBuilder);
            for (Class<?> paramClass : paramClasses) {
                DefaultWorkerExecutor.addVisibilityFor(paramClass, (ImmutableSet.Builder<File>)classpathBuilder);
            }
            ImmutableSet daemonClasspath = classpathBuilder.build();
            if (isolationMode == IsolationMode.PROCESS) {
                builder.withClassLoaderStructure(this.classLoaderStructureProvider.getWorkerProcessClassLoaderStructure((Iterable<File>)daemonClasspath));
            } else {
                builder.withClassLoaderStructure(this.classLoaderStructureProvider.getInProcessClassLoaderStructure((Iterable<File>)daemonClasspath));
            }
        }
        return builder.build();
    }

    private static void addVisibilityFor(Class<?> visibleClass, ImmutableSet.Builder<File> classpathBuilder) {
        if (visibleClass.getClassLoader() != null) {
            classpathBuilder.addAll((Iterable)ClasspathUtil.getClasspath((ClassLoader)visibleClass.getClassLoader()).getAsFiles());
        }
    }

    private static class LazyChildWorkerLeaseLock
    implements ResourceLock {
        private final WorkerLeaseRegistry.WorkerLease parentWorkerLease;
        private WorkerLeaseRegistry.WorkerLease child;

        public LazyChildWorkerLeaseLock(WorkerLeaseRegistry.WorkerLease parentWorkerLease) {
            this.parentWorkerLease = parentWorkerLease;
        }

        public boolean isLocked() {
            return this.getChild().isLocked();
        }

        public boolean isLockedByCurrentThread() {
            return this.getChild().isLockedByCurrentThread();
        }

        public boolean tryLock() {
            this.child = this.parentWorkerLease.createChild();
            if (this.child.tryLock()) {
                return true;
            }
            this.child = null;
            return false;
        }

        public void unlock() {
            this.getChild().unlock();
        }

        public String getDisplayName() {
            return this.getChild().getDisplayName();
        }

        private WorkerLeaseRegistry.WorkerLease getChild() {
            if (this.child == null) {
                throw new IllegalStateException("Detected attempt to access LazyChildWorkerLeaseLock before tryLock() has succeeded.  tryLock must be succeed before other methods are called.");
            }
            return this.child;
        }
    }

    private static class WorkerExecution
    extends AbstractConditionalExecution<DefaultWorkResult>
    implements AsyncWorkCompletion {
        private final String description;

        public WorkerExecution(String description, WorkerLeaseRegistry.WorkerLease parentWorkerLease, Callable<DefaultWorkResult> callable) {
            super(callable, (ResourceLock)new LazyChildWorkerLeaseLock(parentWorkerLease));
            this.description = description;
        }

        public void waitForCompletion() {
            DefaultWorkResult result = (DefaultWorkResult)this.await();
            if (!result.isSuccess()) {
                throw new WorkExecutionException(this.description, result.getException());
            }
        }
    }

    @Contextual
    private static class WorkExecutionException
    extends RuntimeException {
        WorkExecutionException(String description) {
            super(WorkExecutionException.toMessage(description));
        }

        WorkExecutionException(String description, Throwable cause) {
            super(WorkExecutionException.toMessage(description), cause);
        }

        private static String toMessage(String description) {
            return "A failure occurred while executing " + description;
        }
    }
}

