/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.translate.utils.ErrorReportingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.synthetics.SyntheticClassOrObjectDescriptorKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForTypeAliasObject;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

public final class BindingUtils {
    private BindingUtils() {
    }

    @NotNull
    private static <E extends PsiElement, D extends DeclarationDescriptor> D getDescriptorForExpression(@NotNull BindingContext context, @NotNull E expression2, Class<D> descriptorClass) {
        if (context == null) {
            BindingUtils.$$$reportNull$$$1(0);
        }
        if (expression2 == null) {
            BindingUtils.$$$reportNull$$$1(1);
        }
        if (context == null) {
            BindingUtils.$$$reportNull$$$0(0);
        }
        if (expression2 == null) {
            BindingUtils.$$$reportNull$$$0(1);
        }
        DeclarationDescriptor descriptor2 = context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, expression2);
        assert (descriptor2 != null);
        assert (descriptorClass.isInstance(descriptor2)) : ErrorReportingUtils.message(expression2, expression2.toString() + " expected to have of type" + descriptorClass.toString());
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor == null) {
            BindingUtils.$$$reportNull$$$0(2);
        }
        if (declarationDescriptor == null) {
            BindingUtils.$$$reportNull$$$1(2);
        }
        return (D)declarationDescriptor;
    }

    @NotNull
    public static ClassDescriptor getClassDescriptor(@NotNull BindingContext context, @NotNull KtPureClassOrObject declaration) {
        if (context == null) {
            BindingUtils.$$$reportNull$$$1(3);
        }
        if (declaration == null) {
            BindingUtils.$$$reportNull$$$1(4);
        }
        if (context == null) {
            BindingUtils.$$$reportNull$$$0(3);
        }
        if (declaration == null) {
            BindingUtils.$$$reportNull$$$0(4);
        }
        ClassDescriptor classDescriptor2 = SyntheticClassOrObjectDescriptorKt.findClassDescriptor(declaration, context);
        if (classDescriptor2 == null) {
            BindingUtils.$$$reportNull$$$0(5);
        }
        if (classDescriptor2 == null) {
            BindingUtils.$$$reportNull$$$1(5);
        }
        return classDescriptor2;
    }

    @NotNull
    public static FunctionDescriptor getFunctionDescriptor(@NotNull BindingContext context, @NotNull KtDeclarationWithBody declaration) {
        if (context == null) {
            BindingUtils.$$$reportNull$$$1(6);
        }
        if (declaration == null) {
            BindingUtils.$$$reportNull$$$1(7);
        }
        if (context == null) {
            BindingUtils.$$$reportNull$$$0(6);
        }
        if (declaration == null) {
            BindingUtils.$$$reportNull$$$0(7);
        }
        FunctionDescriptor functionDescriptor = BindingUtils.getDescriptorForExpression(context, declaration, FunctionDescriptor.class);
        if (functionDescriptor == null) {
            BindingUtils.$$$reportNull$$$0(8);
        }
        if (functionDescriptor == null) {
            BindingUtils.$$$reportNull$$$1(8);
        }
        return functionDescriptor;
    }

    @NotNull
    public static PropertyDescriptor getPropertyDescriptor(@NotNull BindingContext context, @NotNull KtProperty declaration) {
        if (context == null) {
            BindingUtils.$$$reportNull$$$1(9);
        }
        if (declaration == null) {
            BindingUtils.$$$reportNull$$$1(10);
        }
        if (context == null) {
            BindingUtils.$$$reportNull$$$0(9);
        }
        if (declaration == null) {
            BindingUtils.$$$reportNull$$$0(10);
        }
        PropertyDescriptor propertyDescriptor2 = BindingUtils.getDescriptorForExpression(context, declaration, PropertyDescriptor.class);
        if (propertyDescriptor2 == null) {
            BindingUtils.$$$reportNull$$$0(11);
        }
        if (propertyDescriptor2 == null) {
            BindingUtils.$$$reportNull$$$1(11);
        }
        return propertyDescriptor2;
    }

    @NotNull
    private static KtParameter getParameterForDescriptor(@NotNull ValueParameterDescriptor descriptor2) {
        if (descriptor2 == null) {
            BindingUtils.$$$reportNull$$$1(12);
        }
        if (descriptor2 == null) {
            BindingUtils.$$$reportNull$$$0(12);
        }
        PsiElement result2 = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        assert (result2 instanceof KtParameter) : ErrorReportingUtils.message(descriptor2, "ValueParameterDescriptor should have corresponding JetParameter");
        KtParameter ktParameter = (KtParameter)result2;
        if (ktParameter == null) {
            BindingUtils.$$$reportNull$$$0(13);
        }
        if (ktParameter == null) {
            BindingUtils.$$$reportNull$$$1(13);
        }
        return ktParameter;
    }

    public static boolean hasAncestorClass(@NotNull BindingContext context, @NotNull KtPureClassOrObject classDeclaration) {
        ClassDescriptor classDescriptor2;
        List<ClassDescriptor> superclassDescriptors;
        if (context == null) {
            BindingUtils.$$$reportNull$$$1(14);
        }
        if (classDeclaration == null) {
            BindingUtils.$$$reportNull$$$1(15);
        }
        if (context == null) {
            BindingUtils.$$$reportNull$$$0(14);
        }
        if (classDeclaration == null) {
            BindingUtils.$$$reportNull$$$0(15);
        }
        return JsDescriptorUtils.findAncestorClass(superclassDescriptors = DescriptorUtils.getSuperclassDescriptors(classDescriptor2 = BindingUtils.getClassDescriptor(context, classDeclaration))) != null;
    }

    @NotNull
    public static KotlinType getTypeByReference(@NotNull BindingContext context, @NotNull KtTypeReference typeReference) {
        if (context == null) {
            BindingUtils.$$$reportNull$$$1(16);
        }
        if (typeReference == null) {
            BindingUtils.$$$reportNull$$$1(17);
        }
        if (context == null) {
            BindingUtils.$$$reportNull$$$0(16);
        }
        if (typeReference == null) {
            BindingUtils.$$$reportNull$$$0(17);
        }
        KotlinType kotlinType2 = BindingContextUtils.getNotNull(context, BindingContext.TYPE, typeReference);
        if (kotlinType2 == null) {
            BindingUtils.$$$reportNull$$$0(18);
        }
        if (kotlinType2 == null) {
            BindingUtils.$$$reportNull$$$1(18);
        }
        return kotlinType2;
    }

    @Nullable
    public static PropertyDescriptor getPropertyDescriptorForConstructorParameter(@NotNull BindingContext context, @NotNull KtParameter parameter) {
        if (context == null) {
            BindingUtils.$$$reportNull$$$1(19);
        }
        if (parameter == null) {
            BindingUtils.$$$reportNull$$$1(20);
        }
        if (context == null) {
            BindingUtils.$$$reportNull$$$0(19);
        }
        if (parameter == null) {
            BindingUtils.$$$reportNull$$$0(20);
        }
        return context.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
    }

    @Nullable
    public static DeclarationDescriptor getDescriptorForReferenceExpression(@NotNull BindingContext context, @NotNull KtReferenceExpression reference) {
        if (context == null) {
            BindingUtils.$$$reportNull$$$1(21);
        }
        if (reference == null) {
            BindingUtils.$$$reportNull$$$1(22);
        }
        if (context == null) {
            BindingUtils.$$$reportNull$$$0(21);
        }
        if (reference == null) {
            BindingUtils.$$$reportNull$$$0(22);
        }
        if (BindingContextUtils.isExpressionWithValidReference(reference, context)) {
            return BindingUtils.resolveObjectViaTypeAlias(BindingContextUtils.getNotNull(context, BindingContext.REFERENCE_TARGET, reference));
        }
        return null;
    }

    @Nullable
    private static DeclarationDescriptor getNullableDescriptorForReferenceExpression(@NotNull BindingContext context, @NotNull KtReferenceExpression reference) {
        DeclarationDescriptor descriptor2;
        if (context == null) {
            BindingUtils.$$$reportNull$$$1(23);
        }
        if (reference == null) {
            BindingUtils.$$$reportNull$$$1(24);
        }
        if (context == null) {
            BindingUtils.$$$reportNull$$$0(23);
        }
        if (reference == null) {
            BindingUtils.$$$reportNull$$$0(24);
        }
        return (descriptor2 = context.get(BindingContext.REFERENCE_TARGET, reference)) != null ? BindingUtils.resolveObjectViaTypeAlias(descriptor2) : null;
    }

    @NotNull
    private static DeclarationDescriptor resolveObjectViaTypeAlias(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            BindingUtils.$$$reportNull$$$1(25);
        }
        if (descriptor2 == null) {
            BindingUtils.$$$reportNull$$$0(25);
        }
        if (descriptor2 instanceof TypeAliasDescriptor) {
            ClassDescriptor classDescriptor2 = ((TypeAliasDescriptor)descriptor2).getClassDescriptor();
            assert (classDescriptor2 != null) : "Class descriptor must be non-null in resolved typealias: " + descriptor2;
            if (classDescriptor2.getKind() != ClassKind.OBJECT && classDescriptor2.getKind() != ClassKind.ENUM_CLASS) {
                classDescriptor2 = classDescriptor2.getCompanionObjectDescriptor();
                assert (classDescriptor2 != null) : "Resolved typealias must have non-null class descriptor: " + descriptor2;
            }
            ClassDescriptor classDescriptor3 = classDescriptor2;
            if (classDescriptor3 == null) {
                BindingUtils.$$$reportNull$$$0(26);
            }
            if (classDescriptor3 == null) {
                BindingUtils.$$$reportNull$$$1(26);
            }
            return classDescriptor3;
        }
        if (descriptor2 instanceof FakeCallableDescriptorForTypeAliasObject) {
            ClassDescriptor classDescriptor4 = ((FakeCallableDescriptorForTypeAliasObject)descriptor2).getReferencedObject();
            if (classDescriptor4 == null) {
                BindingUtils.$$$reportNull$$$0(27);
            }
            if (classDescriptor4 == null) {
                BindingUtils.$$$reportNull$$$1(27);
            }
            return classDescriptor4;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor == null) {
            BindingUtils.$$$reportNull$$$0(28);
        }
        if (declarationDescriptor == null) {
            BindingUtils.$$$reportNull$$$1(28);
        }
        return declarationDescriptor;
    }

    public static boolean isVariableReassignment(@NotNull BindingContext context, @NotNull KtExpression expression2) {
        if (context == null) {
            BindingUtils.$$$reportNull$$$1(29);
        }
        if (expression2 == null) {
            BindingUtils.$$$reportNull$$$1(30);
        }
        if (context == null) {
            BindingUtils.$$$reportNull$$$0(29);
        }
        if (expression2 == null) {
            BindingUtils.$$$reportNull$$$0(30);
        }
        return BindingContextUtils.getNotNull(context, BindingContext.VARIABLE_REASSIGNMENT, expression2);
    }

    @Nullable
    public static CallableDescriptor getCallableDescriptorForOperationExpression(@NotNull BindingContext context, @NotNull KtOperationExpression expression2) {
        KtSimpleNameExpression operationReference;
        DeclarationDescriptor descriptorForReferenceExpression;
        if (context == null) {
            BindingUtils.$$$reportNull$$$1(31);
        }
        if (expression2 == null) {
            BindingUtils.$$$reportNull$$$1(32);
        }
        if (context == null) {
            BindingUtils.$$$reportNull$$$0(31);
        }
        if (expression2 == null) {
            BindingUtils.$$$reportNull$$$0(32);
        }
        if ((descriptorForReferenceExpression = BindingUtils.getNullableDescriptorForReferenceExpression(context, operationReference = expression2.getOperationReference())) == null) {
            return null;
        }
        assert (descriptorForReferenceExpression instanceof CallableDescriptor) : ErrorReportingUtils.message(operationReference, "Operation should resolve to callable descriptor");
        return (CallableDescriptor)descriptorForReferenceExpression;
    }

    @NotNull
    public static DeclarationDescriptor getDescriptorForElement(@NotNull BindingContext context, @NotNull PsiElement element) {
        if (context == null) {
            BindingUtils.$$$reportNull$$$1(33);
        }
        if (element == null) {
            BindingUtils.$$$reportNull$$$1(34);
        }
        if (context == null) {
            BindingUtils.$$$reportNull$$$0(33);
        }
        if (element == null) {
            BindingUtils.$$$reportNull$$$0(34);
        }
        DeclarationDescriptor declarationDescriptor = BindingContextUtils.getNotNull(context, BindingContext.DECLARATION_TO_DESCRIPTOR, element);
        if (declarationDescriptor == null) {
            BindingUtils.$$$reportNull$$$0(35);
        }
        if (declarationDescriptor == null) {
            BindingUtils.$$$reportNull$$$1(35);
        }
        return declarationDescriptor;
    }

    @Nullable
    public static Object getCompileTimeValue(@NotNull BindingContext context, @NotNull KtExpression expression2) {
        CompileTimeConstant<?> compileTimeValue;
        if (context == null) {
            BindingUtils.$$$reportNull$$$1(36);
        }
        if (expression2 == null) {
            BindingUtils.$$$reportNull$$$1(37);
        }
        if (context == null) {
            BindingUtils.$$$reportNull$$$0(36);
        }
        if (expression2 == null) {
            BindingUtils.$$$reportNull$$$0(37);
        }
        if ((compileTimeValue = ConstantExpressionEvaluator.getConstant(expression2, context)) != null) {
            return BindingUtils.getCompileTimeValue(context, expression2, compileTimeValue);
        }
        return null;
    }

    @Nullable
    public static Object getCompileTimeValue(@NotNull BindingContext context, @NotNull KtExpression expression2, @NotNull CompileTimeConstant<?> constant) {
        KotlinType expectedType;
        if (context == null) {
            BindingUtils.$$$reportNull$$$1(38);
        }
        if (expression2 == null) {
            BindingUtils.$$$reportNull$$$1(39);
        }
        if (constant == null) {
            BindingUtils.$$$reportNull$$$1(40);
        }
        if (context == null) {
            BindingUtils.$$$reportNull$$$0(38);
        }
        if (expression2 == null) {
            BindingUtils.$$$reportNull$$$0(39);
        }
        if (constant == null) {
            BindingUtils.$$$reportNull$$$0(40);
        }
        return constant.getValue((expectedType = context.getType(expression2)) == null ? TypeUtils.NO_EXPECTED_TYPE : expectedType);
    }

    @NotNull
    public static KtExpression getDefaultArgument(@NotNull ValueParameterDescriptor parameterDescriptor) {
        if (parameterDescriptor == null) {
            BindingUtils.$$$reportNull$$$1(41);
        }
        if (parameterDescriptor == null) {
            BindingUtils.$$$reportNull$$$0(41);
        }
        KtParameter psiParameter = BindingUtils.getParameterForDescriptor(parameterDescriptor);
        KtExpression defaultValue = psiParameter.getDefaultValue();
        assert (defaultValue != null) : ErrorReportingUtils.message(parameterDescriptor, "No default value found in PSI");
        KtExpression ktExpression = defaultValue;
        if (ktExpression == null) {
            BindingUtils.$$$reportNull$$$0(42);
        }
        if (ktExpression == null) {
            BindingUtils.$$$reportNull$$$1(42);
        }
        return ktExpression;
    }

    @NotNull
    public static ResolvedCall<FunctionDescriptor> getIteratorFunction(@NotNull BindingContext context, @NotNull KtExpression rangeExpression) {
        if (context == null) {
            BindingUtils.$$$reportNull$$$1(43);
        }
        if (rangeExpression == null) {
            BindingUtils.$$$reportNull$$$1(44);
        }
        if (context == null) {
            BindingUtils.$$$reportNull$$$0(43);
        }
        if (rangeExpression == null) {
            BindingUtils.$$$reportNull$$$0(44);
        }
        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingContextUtils.getNotNull(context, BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, rangeExpression);
        if (resolvedCall2 == null) {
            BindingUtils.$$$reportNull$$$0(45);
        }
        if (resolvedCall2 == null) {
            BindingUtils.$$$reportNull$$$1(45);
        }
        return resolvedCall2;
    }

    @NotNull
    public static ResolvedCall<FunctionDescriptor> getNextFunction(@NotNull BindingContext context, @NotNull KtExpression rangeExpression) {
        if (context == null) {
            BindingUtils.$$$reportNull$$$1(46);
        }
        if (rangeExpression == null) {
            BindingUtils.$$$reportNull$$$1(47);
        }
        if (context == null) {
            BindingUtils.$$$reportNull$$$0(46);
        }
        if (rangeExpression == null) {
            BindingUtils.$$$reportNull$$$0(47);
        }
        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingContextUtils.getNotNull(context, BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL, rangeExpression);
        if (resolvedCall2 == null) {
            BindingUtils.$$$reportNull$$$0(48);
        }
        if (resolvedCall2 == null) {
            BindingUtils.$$$reportNull$$$1(48);
        }
        return resolvedCall2;
    }

    @NotNull
    public static ResolvedCall<FunctionDescriptor> getHasNextCallable(@NotNull BindingContext context, @NotNull KtExpression rangeExpression) {
        if (context == null) {
            BindingUtils.$$$reportNull$$$1(49);
        }
        if (rangeExpression == null) {
            BindingUtils.$$$reportNull$$$1(50);
        }
        if (context == null) {
            BindingUtils.$$$reportNull$$$0(49);
        }
        if (rangeExpression == null) {
            BindingUtils.$$$reportNull$$$0(50);
        }
        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingContextUtils.getNotNull(context, BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL, rangeExpression);
        if (resolvedCall2 == null) {
            BindingUtils.$$$reportNull$$$0(51);
        }
        if (resolvedCall2 == null) {
            BindingUtils.$$$reportNull$$$1(51);
        }
        return resolvedCall2;
    }

    @NotNull
    public static KotlinType getTypeForExpression(@NotNull BindingContext context, @NotNull KtExpression expression2) {
        if (context == null) {
            BindingUtils.$$$reportNull$$$1(52);
        }
        if (expression2 == null) {
            BindingUtils.$$$reportNull$$$1(53);
        }
        if (context == null) {
            BindingUtils.$$$reportNull$$$0(52);
        }
        if (expression2 == null) {
            BindingUtils.$$$reportNull$$$0(53);
        }
        KotlinType kotlinType2 = BindingContextUtils.getTypeNotNull(context, expression2);
        if (kotlinType2 == null) {
            BindingUtils.$$$reportNull$$$0(54);
        }
        if (kotlinType2 == null) {
            BindingUtils.$$$reportNull$$$1(54);
        }
        return kotlinType2;
    }

    @NotNull
    public static ResolvedCall<FunctionDescriptor> getResolvedCallForArrayAccess(@NotNull BindingContext context, @NotNull KtArrayAccessExpression arrayAccessExpression, boolean isGet) {
        if (context == null) {
            BindingUtils.$$$reportNull$$$1(55);
        }
        if (arrayAccessExpression == null) {
            BindingUtils.$$$reportNull$$$1(56);
        }
        if (context == null) {
            BindingUtils.$$$reportNull$$$0(55);
        }
        if (arrayAccessExpression == null) {
            BindingUtils.$$$reportNull$$$0(56);
        }
        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingContextUtils.getNotNull(context, isGet ? BindingContext.INDEXED_LVALUE_GET : BindingContext.INDEXED_LVALUE_SET, arrayAccessExpression);
        if (resolvedCall2 == null) {
            BindingUtils.$$$reportNull$$$0(57);
        }
        if (resolvedCall2 == null) {
            BindingUtils.$$$reportNull$$$1(57);
        }
        return resolvedCall2;
    }

    @Nullable
    public static ResolvedCall<FunctionDescriptor> getSuperCall(@NotNull BindingContext context, KtPureClassOrObject classDeclaration) {
        if (context == null) {
            BindingUtils.$$$reportNull$$$1(58);
        }
        if (context == null) {
            BindingUtils.$$$reportNull$$$0(58);
        }
        for (KtSuperTypeListEntry specifier : classDeclaration.getSuperTypeListEntries()) {
            if (!(specifier instanceof KtSuperTypeCallEntry)) continue;
            KtSuperTypeCallEntry superCall = (KtSuperTypeCallEntry)specifier;
            return CallUtilKt.getResolvedCallWithAssert(superCall, context);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 35: 
            case 42: 
            case 45: 
            case 48: 
            case 51: 
            case 54: 
            case 57: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 35: 
            case 42: 
            case 45: 
            case 48: 
            case 51: 
            case 54: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 30: 
            case 32: 
            case 37: 
            case 39: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 35: 
            case 42: 
            case 45: 
            case 48: 
            case 51: 
            case 54: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/utils/BindingUtils";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 12: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDeclaration";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeReference";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterDescriptor";
                break;
            }
            case 44: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeExpression";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayAccessExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/utils/BindingUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptorForExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassDescriptor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionDescriptor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyDescriptor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterForDescriptor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeByReference";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveObjectViaTypeAlias";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptorForElement";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultArgument";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getIteratorFunction";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextFunction";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getHasNextCallable";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeForExpression";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedCallForArrayAccess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptorForExpression";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 35: 
            case 42: 
            case 45: 
            case 48: 
            case 51: 
            case 54: 
            case 57: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getClassDescriptor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionDescriptor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyDescriptor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getParameterForDescriptor";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "hasAncestorClass";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTypeByReference";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyDescriptorForConstructorParameter";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptorForReferenceExpression";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getNullableDescriptorForReferenceExpression";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "resolveObjectViaTypeAlias";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isVariableReassignment";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getCallableDescriptorForOperationExpression";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptorForElement";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getCompileTimeValue";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultArgument";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getIteratorFunction";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getNextFunction";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getHasNextCallable";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getTypeForExpression";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedCallForArrayAccess";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getSuperCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 35: 
            case 42: 
            case 45: 
            case 48: 
            case 51: 
            case 54: 
            case 57: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 35: 
            case 42: 
            case 45: 
            case 48: 
            case 51: 
            case 54: 
            case 57: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 35: 
            case 42: 
            case 45: 
            case 48: 
            case 51: 
            case 54: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 30: 
            case 32: 
            case 37: 
            case 39: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 35: 
            case 42: 
            case 45: 
            case 48: 
            case 51: 
            case 54: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/utils/BindingUtils";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 12: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDeclaration";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeReference";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterDescriptor";
                break;
            }
            case 44: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeExpression";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayAccessExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/utils/BindingUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptorForExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassDescriptor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionDescriptor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyDescriptor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterForDescriptor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeByReference";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveObjectViaTypeAlias";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptorForElement";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultArgument";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getIteratorFunction";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextFunction";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getHasNextCallable";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeForExpression";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedCallForArrayAccess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptorForExpression";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 35: 
            case 42: 
            case 45: 
            case 48: 
            case 51: 
            case 54: 
            case 57: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getClassDescriptor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionDescriptor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyDescriptor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getParameterForDescriptor";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "hasAncestorClass";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTypeByReference";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyDescriptorForConstructorParameter";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptorForReferenceExpression";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getNullableDescriptorForReferenceExpression";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "resolveObjectViaTypeAlias";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isVariableReassignment";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getCallableDescriptorForOperationExpression";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptorForElement";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getCompileTimeValue";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultArgument";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getIteratorFunction";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getNextFunction";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getHasNextCallable";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getTypeForExpression";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedCallForArrayAccess";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getSuperCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 35: 
            case 42: 
            case 45: 
            case 48: 
            case 51: 
            case 54: 
            case 57: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

