/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;

public class Queue<T> {
    private Object[] myArray;
    private int myFirst;
    private int myLast;
    private boolean isWrapped;

    public Queue(int initialCapacity) {
        this.myArray = initialCapacity > 0 ? new Object[initialCapacity] : ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public void addLast(T object) {
        int currentSize = this.size();
        if (currentSize == this.myArray.length) {
            this.myArray = this.normalize(Math.max(currentSize * 3 / 2, 10));
            this.myFirst = 0;
            this.myLast = currentSize;
            this.isWrapped = false;
        }
        this.myArray[this.myLast] = object;
        ++this.myLast;
        if (this.myLast == this.myArray.length) {
            this.isWrapped = !this.isWrapped;
            this.myLast = 0;
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.isWrapped ? this.myArray.length - this.myFirst + this.myLast : this.myLast - this.myFirst;
    }

    public T pullFirst() {
        T result2 = this.peekFirst();
        this.myArray[this.myFirst] = null;
        ++this.myFirst;
        if (this.myFirst == this.myArray.length) {
            this.myFirst = 0;
            this.isWrapped = !this.isWrapped;
        }
        return result2;
    }

    public T peekFirst() {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("queue is empty");
        }
        Object t = this.myArray[this.myFirst];
        return (T)t;
    }

    private int copyFromTo(int first2, int last2, Object[] result2, int destinationPos) {
        int length = last2 - first2;
        System.arraycopy(this.myArray, first2, result2, destinationPos, length);
        return length;
    }

    @NotNull
    private T[] normalize(int capacity) {
        Object[] result2 = new Object[capacity];
        Object[] objectArray = this.normalize(result2);
        if (objectArray == null) {
            Queue.$$$reportNull$$$0(3);
        }
        return objectArray;
    }

    @NotNull
    private T[] normalize(T[] result2) {
        if (this.isWrapped) {
            int tailLength = this.copyFromTo(this.myFirst, this.myArray.length, result2, 0);
            this.copyFromTo(0, this.myLast, result2, tailLength);
        } else {
            this.copyFromTo(this.myFirst, this.myLast, result2, 0);
        }
        if (result2 == null) {
            Queue.$$$reportNull$$$0(4);
        }
        return result2;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "<empty>";
        }
        return this.isWrapped ? "[ " + this.sub(this.myFirst, this.myArray.length) + " ||| " + this.sub(0, this.myLast) + " ]" : "[ " + this.sub(this.myFirst, this.myLast) + " ]";
    }

    private Object sub(int start, int end) {
        if (start == end) {
            return "";
        }
        return Arrays.asList(this.myArray).subList(start, end);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/Queue";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "toList";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "normalize";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/Queue";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

