/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.StubPsiFactory;
import org.jetbrains.kotlin.com.intellij.psi.stubs.ILightStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.ICompositeElementType;

public abstract class JavaStubElementType<StubT extends StubElement, PsiT extends PsiElement>
extends ILightStubElementType<StubT, PsiT>
implements ICompositeElementType {
    private final boolean myLeftBound;

    protected JavaStubElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            JavaStubElementType.$$$reportNull$$$0(0);
        }
        this(debugName, false);
    }

    protected JavaStubElementType(@NotNull @NonNls String debugName, boolean leftBound) {
        if (debugName == null) {
            JavaStubElementType.$$$reportNull$$$0(1);
        }
        super(debugName, JavaLanguage.INSTANCE);
        this.myLeftBound = leftBound;
    }

    @Override
    @NotNull
    public String getExternalId() {
        String string = "java." + this.toString();
        if (string == null) {
            JavaStubElementType.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected StubPsiFactory getPsiFactory(StubT stub) {
        return this.getFileStub(stub).getPsiFactory();
    }

    public boolean isCompiled(StubT stub) {
        return this.getFileStub(stub).isCompiled();
    }

    private PsiJavaFileStub getFileStub(StubT stub) {
        Object parent2 = stub;
        while (!(parent2 instanceof PsiFileStub)) {
            parent2 = parent2.getParentStub();
        }
        return (PsiJavaFileStub)parent2;
    }

    @Override
    public abstract PsiT createPsi(@NotNull ASTNode var1);

    @Override
    @NotNull
    public final StubT createStub(@NotNull PsiT psi, StubElement parentStub) {
        if (psi == null) {
            JavaStubElementType.$$$reportNull$$$0(3);
        }
        String message = "Should not be called. Element=" + psi + "; class" + psi.getClass() + "; file=" + (psi.isValid() ? psi.getContainingFile() : "-");
        throw new UnsupportedOperationException(message);
    }

    @Override
    public boolean isLeftBound() {
        return this.myLeftBound;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaStubElementType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaStubElementType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

