/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.scala;

import java.io.File;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.tasks.scala.DaemonScalaCompiler;
import org.gradle.api.internal.tasks.scala.NormalizingScalaCompiler;
import org.gradle.api.internal.tasks.scala.ScalaJavaJointCompileSpec;
import org.gradle.api.internal.tasks.scala.ZincScalaCompiler;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.compile.CompilerFactory;
import org.gradle.process.internal.JavaForkOptionsFactory;
import org.gradle.workers.internal.WorkerDaemonFactory;

public class ScalaCompilerFactory
implements CompilerFactory<ScalaJavaJointCompileSpec> {
    private final WorkerDaemonFactory workerDaemonFactory;
    private FileCollection scalaClasspath;
    private FileCollection zincClasspath;
    private final File daemonWorkingDir;
    private final File gradleUserHomeDir;
    private final JavaForkOptionsFactory forkOptionsFactory;
    private final ClassPathRegistry classPathRegistry;
    private final ClassLoaderRegistry classLoaderRegistry;

    public ScalaCompilerFactory(File daemonWorkingDir, WorkerDaemonFactory workerDaemonFactory, FileCollection scalaClasspath, FileCollection zincClasspath, File gradleUserHomeDir, JavaForkOptionsFactory forkOptionsFactory, ClassPathRegistry classPathRegistry, ClassLoaderRegistry classLoaderRegistry) {
        this.daemonWorkingDir = daemonWorkingDir;
        this.workerDaemonFactory = workerDaemonFactory;
        this.scalaClasspath = scalaClasspath;
        this.zincClasspath = zincClasspath;
        this.gradleUserHomeDir = gradleUserHomeDir;
        this.forkOptionsFactory = forkOptionsFactory;
        this.classPathRegistry = classPathRegistry;
        this.classLoaderRegistry = classLoaderRegistry;
    }

    public Compiler<ScalaJavaJointCompileSpec> newCompiler(ScalaJavaJointCompileSpec spec) {
        Set scalaClasspathFiles = this.scalaClasspath.getFiles();
        Set zincClasspathFiles = this.zincClasspath.getFiles();
        DaemonScalaCompiler scalaCompiler = new DaemonScalaCompiler(this.daemonWorkingDir, ZincScalaCompiler.class, new Object[]{scalaClasspathFiles, zincClasspathFiles, this.gradleUserHomeDir}, this.workerDaemonFactory, (Iterable)zincClasspathFiles, this.forkOptionsFactory, this.classPathRegistry, this.classLoaderRegistry);
        return new NormalizingScalaCompiler((Compiler)scalaCompiler);
    }
}

