/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker.request;

import com.google.common.primitives.Primitives;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.gradle.internal.Cast;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Message;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SerializerRegistry;
import org.gradle.process.internal.worker.request.Request;

public class RequestSerializer
implements Serializer<Request> {
    private final List<SerializerRegistry> registries;
    private final ClassLoader classLoader;
    private final JavaObjectSerializer javaObjectSerializer;

    public RequestSerializer(ClassLoader classLoader, List<SerializerRegistry> registries) {
        this.registries = registries;
        this.classLoader = classLoader;
        this.javaObjectSerializer = new JavaObjectSerializer(classLoader);
    }

    public void write(Encoder encoder, Request request) throws Exception {
        encoder.writeString((CharSequence)request.getMethodName());
        encoder.writeInt(request.getParamTypes().length);
        for (Class<?> type : request.getParamTypes()) {
            encoder.writeString((CharSequence)Primitives.wrap(type).getName());
        }
        if (request.getArgs() != null) {
            for (Object object : request.getArgs()) {
                if (object == null) {
                    encoder.writeString((CharSequence)NullType.class.getName());
                    continue;
                }
                Class<?> type = object.getClass();
                encoder.writeString((CharSequence)Primitives.wrap(type).getName());
                this.select(type).write(encoder, object);
            }
        }
        this.javaObjectSerializer.write(encoder, request.getBuildOperation());
    }

    public Request read(Decoder decoder) throws Exception {
        String methodName = decoder.readString();
        int numParams = decoder.readInt();
        Class[] paramTypes = new Class[numParams];
        for (int i = 0; i < numParams; ++i) {
            paramTypes[i] = Primitives.unwrap(this.classLoader.loadClass(decoder.readString()));
        }
        Object[] args = new Object[numParams];
        for (int i = 0; i < numParams; ++i) {
            Class type = Primitives.unwrap(this.classLoader.loadClass(decoder.readString()));
            args[i] = type == NullType.class ? null : this.select(type).read(decoder);
        }
        BuildOperationRef buildOperation = (BuildOperationRef)this.javaObjectSerializer.read(decoder);
        return new Request(methodName, paramTypes, args, buildOperation);
    }

    private Serializer<Object> select(Class<?> type) {
        for (SerializerRegistry registry : this.registries) {
            if (!registry.canSerialize(type)) continue;
            return (Serializer)Cast.uncheckedCast((Object)registry.build(type));
        }
        return this.javaObjectSerializer;
    }

    private static class JavaObjectSerializer
    implements Serializer<Object> {
        private final ClassLoader classLoader;

        public JavaObjectSerializer(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public Object read(Decoder decoder) throws Exception {
            return Message.receive((InputStream)decoder.getInputStream(), (ClassLoader)this.classLoader);
        }

        public void write(Encoder encoder, Object value) throws Exception {
            Message.send((Object)value, (OutputStream)encoder.getOutputStream());
        }
    }

    private static class NullType {
        private NullType() {
        }
    }
}

