/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.local;

import java.io.File;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.internal.resource.local.DefaultPathKeyFileStore;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.FileStoreSearcher;
import org.gradle.internal.resource.local.LocallyAvailableResource;

public class PathNormalisingKeyFileStore
implements FileStore<String>,
FileStoreSearcher<String> {
    private final DefaultPathKeyFileStore delegate;

    public PathNormalisingKeyFileStore(File baseDir) {
        this.delegate = new DefaultPathKeyFileStore(baseDir);
    }

    public LocallyAvailableResource move(String key, File source) {
        return this.delegate.move(this.normalizePath(key), source);
    }

    protected String normalizePath(String path) {
        return path.replaceAll("[^\\d\\w\\./]", "_");
    }

    protected String normalizeSearchPath(String path) {
        return path.replaceAll("[^\\d\\w\\.\\*/]", "_");
    }

    public LocallyAvailableResource add(String key, Action<File> addAction) {
        return this.delegate.add(this.normalizePath(key), addAction);
    }

    public Set<? extends LocallyAvailableResource> search(String key) {
        return this.delegate.search(this.normalizeSearchPath(key));
    }
}

