/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.io.IOException;
import org.simpleframework.http.ContentType;
import org.simpleframework.http.Form;
import org.simpleframework.http.Part;
import org.simpleframework.http.Query;
import org.simpleframework.http.Request;
import org.simpleframework.http.core.Body;
import org.simpleframework.http.core.Entity;
import org.simpleframework.http.core.PartForm;
import org.simpleframework.http.core.PartList;
import org.simpleframework.http.core.QueryForm;

class FormCreator {
    private final Request request;
    private final Body body;

    public FormCreator(Request request, Entity entity) {
        this.body = entity.getBody();
        this.request = request;
    }

    public Form getInstance() throws IOException {
        PartList list = this.getParts();
        Query form = this.getQuery();
        for (Part part : list) {
            String name = part.getName();
            String value = part.getContent();
            form.put(name, value);
        }
        return new PartForm(this.body, form);
    }

    private Query getQuery() throws IOException {
        Query query = this.request.getQuery();
        if (!this.isFormPost()) {
            return query;
        }
        return this.getQuery(query);
    }

    private Query getQuery(Query query) throws IOException {
        String body = this.request.getContent();
        if (body == null) {
            return query;
        }
        return new QueryForm(query, body);
    }

    private PartList getParts() {
        PartList list = this.body.getParts();
        if (list.isEmpty()) {
            return list;
        }
        return this.getParts(list);
    }

    private PartList getParts(PartList body) {
        PartList list = new PartList();
        for (Part part : body) {
            if (part.isFile()) continue;
            list.add(part);
        }
        return list;
    }

    private boolean isFormPost() {
        ContentType type = this.request.getContentType();
        if (type == null) {
            return false;
        }
        return this.isFormPost(type);
    }

    private boolean isFormPost(ContentType type) {
        String primary = type.getPrimary();
        String secondary = type.getSecondary();
        if (!primary.equals("application")) {
            return false;
        }
        return secondary.equals("x-www-form-urlencoded");
    }
}

