/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.twirl.internal;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.gradle.language.base.sources.BaseLanguageSourceSet;
import org.gradle.language.twirl.TwirlImports;
import org.gradle.language.twirl.TwirlSourceSet;
import org.gradle.language.twirl.TwirlTemplateFormat;
import org.gradle.language.twirl.internal.DefaultTwirlTemplateFormat;

public class DefaultTwirlSourceSet
extends BaseLanguageSourceSet
implements TwirlSourceSet {
    private TwirlImports defaultImports = TwirlImports.SCALA;
    private List<TwirlTemplateFormat> userTemplateFormats = Lists.newArrayList();
    private List<String> additionalImports = Lists.newArrayList();

    protected String getLanguageName() {
        return "Twirl template";
    }

    @Override
    public TwirlImports getDefaultImports() {
        return this.defaultImports;
    }

    @Override
    public void setDefaultImports(TwirlImports defaultImports) {
        this.defaultImports = defaultImports;
    }

    @Override
    public List<TwirlTemplateFormat> getUserTemplateFormats() {
        return this.userTemplateFormats;
    }

    @Override
    public void setUserTemplateFormats(List<TwirlTemplateFormat> userTemplateFormats) {
        this.userTemplateFormats = userTemplateFormats;
    }

    @Override
    public void addUserTemplateFormat(String extension, String templateType, String ... imports) {
        this.userTemplateFormats.add(new DefaultTwirlTemplateFormat(extension, templateType, Arrays.asList(imports)));
    }

    @Override
    public List<String> getAdditionalImports() {
        return this.additionalImports;
    }

    @Override
    public void setAdditionalImports(List<String> additionalImports) {
        this.additionalImports = additionalImports;
    }
}

