/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencySubstitution;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.composite.CompositeBuildContext;
import org.gradle.composite.internal.CompositeBuildDependencySubstitutions;
import org.gradle.internal.Actions;
import org.gradle.internal.Pair;

public class DefaultBuildableCompositeBuildContext
implements CompositeBuildContext {
    private final Set<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>> availableModules = Sets.newHashSet();
    private final List<Action<DependencySubstitution>> substitutionRules = Lists.newArrayList();

    public void addAvailableModules(Set<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>> availableModules) {
        this.availableModules.addAll(availableModules);
    }

    public void registerSubstitution(Action<DependencySubstitution> substitutions) {
        this.substitutionRules.add(substitutions);
    }

    public Action<DependencySubstitution> getRuleAction() {
        ArrayList allActions = Lists.newArrayList();
        if (!this.availableModules.isEmpty()) {
            allActions.add(new CompositeBuildDependencySubstitutions(this.availableModules));
        }
        allActions.addAll(this.substitutionRules);
        return Actions.composite((List)allActions);
    }

    public boolean hasRules() {
        return !this.availableModules.isEmpty() || !this.substitutionRules.isEmpty();
    }
}

