/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import org.gradle.api.internal.artifacts.transform.Transformer;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.gradle.internal.hash.Hasher;

public abstract class AbstractTransformer<T>
implements Transformer {
    private final Class<? extends T> implementationClass;
    private final ImmutableAttributes fromAttributes;

    public AbstractTransformer(Class<? extends T> implementationClass, ImmutableAttributes fromAttributes) {
        this.implementationClass = implementationClass;
        this.fromAttributes = fromAttributes;
    }

    @Override
    public ImmutableAttributes getFromAttributes() {
        return this.fromAttributes;
    }

    public Class<? extends T> getImplementationClass() {
        return this.implementationClass;
    }

    public String getDisplayName() {
        return this.implementationClass.getSimpleName();
    }

    protected static void appendActionImplementation(Class<?> implementation, Hasher hasher, ClassLoaderHierarchyHasher classLoaderHierarchyHasher) {
        hasher.putString((CharSequence)implementation.getName());
        hasher.putHash(classLoaderHierarchyHasher.getClassLoaderHash(implementation.getClassLoader()));
    }
}

