/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.PreUploadHook;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.UploadPack;

public class PreUploadHookChain
implements PreUploadHook {
    private final PreUploadHook[] hooks;
    private final int count;

    public static PreUploadHook newChain(List<? extends PreUploadHook> hooks) {
        PreUploadHook[] newHooks = new PreUploadHook[hooks.size()];
        int i = 0;
        for (PreUploadHook preUploadHook : hooks) {
            if (preUploadHook == PreUploadHook.NULL) continue;
            newHooks[i++] = preUploadHook;
        }
        if (i == 0) {
            return PreUploadHook.NULL;
        }
        if (i == 1) {
            return newHooks[0];
        }
        return new PreUploadHookChain(newHooks, i);
    }

    @Override
    public void onBeginNegotiateRound(UploadPack up, Collection<? extends ObjectId> wants, int cntOffered) throws ServiceMayNotContinueException {
        int i = 0;
        while (i < this.count) {
            this.hooks[i].onBeginNegotiateRound(up, wants, cntOffered);
            ++i;
        }
    }

    @Override
    public void onEndNegotiateRound(UploadPack up, Collection<? extends ObjectId> wants, int cntCommon, int cntNotFound, boolean ready) throws ServiceMayNotContinueException {
        int i = 0;
        while (i < this.count) {
            this.hooks[i].onEndNegotiateRound(up, wants, cntCommon, cntNotFound, ready);
            ++i;
        }
    }

    @Override
    public void onSendPack(UploadPack up, Collection<? extends ObjectId> wants, Collection<? extends ObjectId> haves) throws ServiceMayNotContinueException {
        int i = 0;
        while (i < this.count) {
            this.hooks[i].onSendPack(up, wants, haves);
            ++i;
        }
    }

    private PreUploadHookChain(PreUploadHook[] hooks, int count) {
        this.hooks = hooks;
        this.count = count;
    }
}

