/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.event.mouse;

import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AnimatedPickingGraphMousePlugin;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualGraphViewUpdater;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.event.mouse.VisualGraphMousePlugin;
import java.awt.Cursor;
import java.awt.event.MouseEvent;

public class VisualGraphAnimatedPickingGraphMousePlugin<V extends VisualVertex, E extends VisualEdge<V>>
extends AnimatedPickingGraphMousePlugin<V, E>
implements VisualGraphMousePlugin<V, E> {
    private boolean isHandlingMouseEvents;

    public VisualGraphAnimatedPickingGraphMousePlugin() {
        super(1024);
        this.cursor = Cursor.getPredefinedCursor(12);
    }

    public void mousePressed(MouseEvent e) {
        if (e.getClickCount() != 2) {
            return;
        }
        super.mousePressed(e);
        if (this.vertex == null) {
            return;
        }
        this.isHandlingMouseEvents = true;
    }

    public void mouseClicked(MouseEvent e) {
        if (!this.checkModifiers(e) || !this.isHandlingMouseEvents) {
            return;
        }
        this.isHandlingMouseEvents = false;
        GraphViewer viewer = this.getGraphViewer(e);
        VisualGraphViewUpdater updater = viewer.getViewUpdater();
        updater.moveVertexToCenterWithAnimation((VisualVertex)this.vertex);
        e.consume();
        this.vertex = null;
    }

    public void mouseDragged(MouseEvent e) {
        if (this.isHandlingMouseEvents) {
            e.consume();
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (this.isHandlingMouseEvents) {
            e.consume();
        }
        if (this.isOverVertex(e)) {
            this.installCursor(this.cursor, e);
            e.consume();
        }
    }

    private boolean isOverVertex(MouseEvent e) {
        VisualizationViewer viewer = (VisualizationViewer)e.getSource();
        return GraphViewerUtils.getVertexFromPointInViewSpace(viewer, e.getPoint()) != null;
    }

    private void installCursor(Cursor newCursor, MouseEvent e) {
        VisualizationViewer viewer = (VisualizationViewer)e.getSource();
        viewer.setCursor(newCursor);
    }

    public void mouseReleased(MouseEvent e) {
        if (this.isHandlingMouseEvents) {
            e.consume();
        }
    }
}

