/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import ghidra.framework.model.AbortedTransactionListener;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.listing.ProgramUserData;
import ghidra.util.Msg;
import javax.help.UnsupportedOperationException;

public interface UndoableTransaction
extends AutoCloseable {
    public static UndoableTransaction start(UndoableDomainObject domainObject, String description, boolean commitByDefault) {
        int tid = domainObject.startTransaction(description);
        return new DomainObjectUndoableTransaction(domainObject, tid, commitByDefault);
    }

    public static UndoableTransaction start(UndoableDomainObject domainObject, String description, AbortedTransactionListener listener, boolean commitByDefault) {
        int tid = domainObject.startTransaction(description, listener);
        return new DomainObjectUndoableTransaction(domainObject, tid, commitByDefault);
    }

    public static UndoableTransaction start(DataTypeManager dataTypeManager, String description, boolean commitByDefault) {
        int tid = dataTypeManager.startTransaction(description);
        return new DataTypeManagerUndoableTransaction(dataTypeManager, tid, commitByDefault);
    }

    public static UndoableTransaction start(ProgramUserData userData) {
        int tid = userData.startTransaction();
        return new ProgramUserDataUndoableTransaction(userData, tid);
    }

    public void commit();

    public void abort();

    @Override
    public void close();

    public static class ProgramUserDataUndoableTransaction
    extends AbstractUndoableTransaction {
        private final ProgramUserData userData;

        private ProgramUserDataUndoableTransaction(ProgramUserData userData, int tid) {
            super(tid, true);
            this.userData = userData;
        }

        @Override
        public void abort() {
            throw new UnsupportedOperationException();
        }

        @Override
        void endTransaction(boolean commit) {
            this.userData.endTransaction(this.transactionID);
        }
    }

    public static class DataTypeManagerUndoableTransaction
    extends AbstractUndoableTransaction {
        private final DataTypeManager dataTypeManager;

        private DataTypeManagerUndoableTransaction(DataTypeManager dataTypeManager, int tid, boolean commitByDefault) {
            super(tid, commitByDefault);
            this.dataTypeManager = dataTypeManager;
        }

        @Override
        void endTransaction(boolean commit) {
            this.dataTypeManager.endTransaction(this.transactionID, commit);
        }
    }

    public static class DomainObjectUndoableTransaction
    extends AbstractUndoableTransaction {
        private final UndoableDomainObject domainObject;

        private DomainObjectUndoableTransaction(UndoableDomainObject domainObject, int tid, boolean commitByDefault) {
            super(tid, commitByDefault);
            this.domainObject = domainObject;
        }

        @Override
        void endTransaction(boolean commit) {
            if (!commit) {
                Msg.debug((Object)this, (Object)"Aborting transaction");
            }
            this.domainObject.endTransaction(this.transactionID, commit);
        }
    }

    public static abstract class AbstractUndoableTransaction
    implements UndoableTransaction {
        protected final int transactionID;
        private boolean commit;
        private boolean open = true;

        private AbstractUndoableTransaction(int transactionID, boolean commitByDefault) {
            this.transactionID = transactionID;
            this.commit = commitByDefault;
        }

        abstract void endTransaction(boolean var1);

        @Override
        public void abort() {
            if (this.open) {
                this.open = false;
                this.endTransaction(false);
            }
        }

        @Override
        public void commit() {
            if (this.open) {
                this.open = false;
                this.endTransaction(true);
            }
        }

        @Override
        public void close() {
            if (this.open) {
                this.open = false;
                this.endTransaction(this.commit);
            }
        }
    }
}

