/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.mem.MemBuffer;
import java.util.HashMap;
import java.util.Map;

public class AddressOfPcodeExecutorState
implements PcodeExecutorStatePiece<byte[], Address> {
    private final boolean isBigEndian;
    private Map<Long, Address> unique = new HashMap<Long, Address>();

    public AddressOfPcodeExecutorState(boolean isBigEndian) {
        this.isBigEndian = isBigEndian;
    }

    @Override
    public byte[] longToOffset(AddressSpace space, long l) {
        return Utils.longToBytes((long)l, (int)space.getPointerSize(), (boolean)this.isBigEndian);
    }

    @Override
    public void setVar(AddressSpace space, byte[] offset, int size, boolean truncateAddressableUnit, Address val) {
        if (!space.isUniqueSpace()) {
            return;
        }
        long off = Utils.bytesToLong((byte[])offset, (int)offset.length, (boolean)this.isBigEndian);
        this.unique.put(off, val);
    }

    @Override
    public Address getVar(AddressSpace space, byte[] offset, int size, boolean truncateAddressableUnit) {
        long off = Utils.bytesToLong((byte[])offset, (int)offset.length, (boolean)this.isBigEndian);
        if (!space.isUniqueSpace()) {
            return space.getAddress(off);
        }
        return this.unique.get(off);
    }

    @Override
    public MemBuffer getConcreteBuffer(Address address) {
        throw new AssertionError((Object)"Cannot make 'address of' concrete buffers");
    }
}

