/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.PeCoffSectionMsSymbol;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.SymbolGroup;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;

public class PeCoffSectionSymbolApplier
extends MsSymbolApplier {
    private PeCoffSectionMsSymbol symbol;

    public PeCoffSectionSymbolApplier(PdbApplicator applicator, SymbolGroup.AbstractMsSymbolIterator iter) {
        super(applicator, iter);
        AbstractMsSymbol abstractSymbol = iter.next();
        if (!(abstractSymbol instanceof PeCoffSectionMsSymbol)) {
            throw new AssertException("Invalid symbol type: " + abstractSymbol.getClass().getSimpleName());
        }
        this.symbol = (PeCoffSectionMsSymbol)abstractSymbol;
    }

    @Override
    void apply() throws PdbException, CancelledException {
        int sectionNum = this.symbol.getSectionNumber();
        long realAddress = this.symbol.getRva();
        this.symbol.getLength();
        this.symbol.getCharacteristics();
        this.symbol.getAlign();
        this.symbol.getName();
        this.applicator.putRealAddressesBySection(sectionNum, realAddress);
        this.applicator.addMemorySectionRefinement(this.symbol);
    }

    @Override
    void applyTo(MsSymbolApplier applyToApplier) {
    }
}

