/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicator;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.CancelledException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public abstract class MsTypeApplier {
    protected PdbApplicator applicator;
    protected AbstractMsType msType;
    protected int index;
    protected DataType dataType;
    protected DataType resolvedDataType;
    protected boolean resolved = false;
    protected boolean applied = false;
    private boolean isDeferred = false;
    protected Set<MsTypeApplier> waitSet = new HashSet<MsTypeApplier>();

    public MsTypeApplier(PdbApplicator applicator, AbstractMsType msType) {
        this.applicator = applicator;
        this.msType = msType;
        RecordNumber recordNumber = msType.getRecordNumber();
        this.index = recordNumber != null ? recordNumber.getNumber() : -1;
        this.dataType = null;
    }

    protected void pdbLogAndInfoMessage(Object originator, String message) {
        this.applicator.pdbLogAndInfoMessage(originator, message);
    }

    boolean isApplied() {
        return this.applied;
    }

    void setApplied() {
        this.applied = true;
    }

    void setDeferred() {
        this.isDeferred = true;
    }

    boolean isDeferred() {
        return this.isDeferred;
    }

    void deferredApply() throws PdbException, CancelledException {
    }

    MsTypeApplier getDependencyApplier() {
        return this;
    }

    void resolve() {
        if (this.resolved) {
            return;
        }
        if (this.dataType != null) {
            this.resolvedDataType = this.applicator.resolve(this.dataType);
        }
        this.resolved = true;
    }

    AbstractMsType getMsType() {
        return this.msType;
    }

    DataType getDataType() {
        if (this.resolved) {
            return this.resolvedDataType;
        }
        return this.dataType;
    }

    DataType getCycleBreakType() {
        return this.getDataType();
    }

    abstract void apply() throws PdbException, CancelledException;

    abstract BigInteger getSize();

    long getSizeLong() {
        return PdbApplicator.bigIntegerToLong(this.applicator, this.getSize());
    }

    int getSizeInt() {
        return PdbApplicator.bigIntegerToInt(this.applicator, this.getSize());
    }

    public String toString() {
        return this.msType.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.index;
        result = 31 * result + this.msType.getClass().getSimpleName().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MsTypeApplier other = (MsTypeApplier)obj;
        if (this.index != other.index) {
            return false;
        }
        return this.msType.getClass().getSimpleName().equals(other.msType.getClass().getSimpleName());
    }

    protected void waitSetPut(MsTypeApplier applier) {
        this.waitSet.add(applier);
    }

    protected boolean waitSetRemove(MsTypeApplier applier) {
        return this.waitSet.remove(applier);
    }

    protected boolean waitSetIsEmpty() {
        return this.waitSet.isEmpty();
    }

    protected MsTypeApplier waitSetGetNext() {
        ArrayList<MsTypeApplier> list = new ArrayList<MsTypeApplier>(this.waitSet);
        return (MsTypeApplier)list.get(0);
    }
}

