/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.SymbolGroup;
import ghidra.util.exception.CancelledException;
import java.util.Objects;

public abstract class MsSymbolApplier {
    protected PdbApplicator applicator;
    protected SymbolGroup.AbstractMsSymbolIterator iter;
    protected long currentOffset;

    public MsSymbolApplier(PdbApplicator applicator, SymbolGroup.AbstractMsSymbolIterator iter) {
        Objects.requireNonNull(applicator, "applicator cannot be null");
        Objects.requireNonNull(iter, "iter cannot be null");
        this.applicator = applicator;
        this.iter = iter;
        this.currentOffset = iter.getCurrentOffset();
    }

    protected void pdbLogAndInfoMessage(Object originator, String message) {
        this.applicator.pdbLogAndInfoMessage(originator, message);
    }

    protected void resetOffset() {
        this.iter.initGetByOffset(this.currentOffset);
    }

    abstract void apply() throws PdbException, CancelledException;

    abstract void applyTo(MsSymbolApplier var1) throws PdbException, CancelledException;

    void manageBlockNesting(MsSymbolApplier applierParam) {
    }
}

