/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AddressMsSymbol;

public class SeparatedCodeFromCompilerSupportMsSymbol
extends AbstractMsSymbol
implements AddressMsSymbol {
    public static final int PDB_ID = 4402;
    private long parentPointer;
    private long endPointer;
    private long blockLength;
    private boolean isLexicalScope;
    private boolean returnsToParent;
    private long offset;
    private long offsetParent;
    private int section;
    private int sectionParent;

    public SeparatedCodeFromCompilerSupportMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.parentPointer = reader.parseUnsignedIntVal();
        this.endPointer = reader.parseUnsignedIntVal();
        this.blockLength = reader.parseUnsignedIntVal();
        this.processFlags(reader.parseUnsignedIntVal());
        this.offset = reader.parseUnsignedIntVal();
        this.offsetParent = reader.parseUnsignedIntVal();
        this.section = pdb.parseSegment(reader);
        this.sectionParent = pdb.parseSegment(reader);
    }

    @Override
    public int getPdbId() {
        return 4402;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s: [%04X:%08X], Length: %08X, ", this.getSymbolTypeName(), this.section, this.offset, this.blockLength));
        builder.append(String.format("Parent: %08X, End: %08X\n", this.parentPointer, this.endPointer));
        builder.append(String.format("   Parent scope beings: [%04X:%08X]\n", this.sectionParent, this.offsetParent));
        builder.append("   Separated code flags:");
        builder.append(this.isLexicalScope ? " lexscope" : "");
        builder.append(this.returnsToParent ? " retparent" : "");
    }

    @Override
    protected String getSymbolTypeName() {
        return "SEPCODE";
    }

    public long getParentPointer() {
        return this.parentPointer;
    }

    public long getEndPointer() {
        return this.endPointer;
    }

    public long getBlockLength() {
        return this.blockLength;
    }

    public boolean isLexicalScope() {
        return this.isLexicalScope;
    }

    public boolean returnsToParent() {
        return this.returnsToParent;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    public long getOffsetParent() {
        return this.offsetParent;
    }

    @Override
    public int getSegment() {
        return this.section;
    }

    public long getSegmentParent() {
        return this.sectionParent;
    }

    protected void processFlags(long flagsIn) {
        this.isLexicalScope = (flagsIn & 1L) == 1L;
        this.returnsToParent = ((flagsIn >>= 1) & 1L) == 1L;
    }
}

