/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractParsableItem;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;

public class AddressRange
extends AbstractParsableItem {
    private long startOffset;
    private int sectionStart;
    private int lengthRange;

    public AddressRange(PdbByteReader reader) throws PdbException {
        this.startOffset = reader.parseUnsignedIntVal();
        this.sectionStart = reader.parseUnsignedShortVal();
        this.lengthRange = reader.parseUnsignedShortVal();
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public int getSectionStart() {
        return this.sectionStart;
    }

    public int getLengthRange() {
        return this.lengthRange;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("   Range: [%04X:%08X] - [%04X:%08X]", this.sectionStart, this.startOffset, this.sectionStart, this.startOffset + (long)this.lengthRange));
    }
}

