/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractTypeProgramInterface;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import java.io.IOException;
import java.io.Writer;

public class TypeProgramInterface200
extends AbstractTypeProgramInterface {
    protected int hashStreamNumber;

    public TypeProgramInterface200(AbstractPdb pdb, RecordCategory recordCategory, int streamNumber) {
        super(pdb, recordCategory, streamNumber);
    }

    @Override
    protected void deserializeHeader(PdbByteReader reader) throws PdbException {
        this.versionNumber = reader.parseInt();
        this.headerLength = 16;
        this.typeIndexMin = reader.parseUnsignedShortVal();
        this.typeIndexMaxExclusive = reader.parseUnsignedShortVal();
        this.dataLength = reader.parseInt();
        this.hashStreamNumber = reader.parseUnsignedShortVal();
        reader.align4();
        this.hash.initHeader200500(this.hashStreamNumber, this.typeIndexMin, this.typeIndexMaxExclusive);
    }

    @Override
    protected void dumpHeader(Writer writer) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("\nversionNumber: ");
        builder.append(this.versionNumber);
        builder.append("\ntypeIndexMin: ");
        builder.append(this.typeIndexMin);
        builder.append("\ntypeIndexMaxExclusive: ");
        builder.append(this.typeIndexMaxExclusive);
        builder.append("\ndataLength: ");
        builder.append(this.dataLength);
        builder.append("\nhashStreamNumber: ");
        builder.append(this.hashStreamNumber);
        writer.write(builder.toString());
    }

    TypeProgramInterface200(AbstractPdb pdb, int typeIndexMin, int typeIndexMaxExclusive) {
        super(pdb, typeIndexMin, typeIndexMaxExclusive);
    }
}

