/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.yaffs2;

import ghidra.file.formats.yaffs2.YAFFS2ExtendedTags;
import ghidra.file.formats.yaffs2.YAFFS2Header;
import java.util.Arrays;

public class YAFFS2Entry {
    private long fileOffset;
    private YAFFS2Header header;
    private YAFFS2ExtendedTags extendedTags;

    public YAFFS2Entry(byte[] buffer) {
        this.header = new YAFFS2Header(Arrays.copyOfRange(buffer, 0, 512));
        this.extendedTags = new YAFFS2ExtendedTags(Arrays.copyOfRange(buffer, 2048, 2112));
    }

    public YAFFS2Entry() {
    }

    public long getObjectId() {
        return this.extendedTags.getObjectId();
    }

    public boolean isDirectory() {
        return this.header.isDirectory();
    }

    public short getChecksum() {
        return this.header.getChecksum();
    }

    public String getName() {
        return this.header.getName();
    }

    public long getYstMode() {
        return this.header.getYstMode();
    }

    public long getYstUId() {
        return this.header.getYstUId();
    }

    public long getYstGId() {
        return this.header.getYstGId();
    }

    public String getYstATime() {
        return this.header.getYstATime();
    }

    public String getYstMTime() {
        return this.header.getYstMTime();
    }

    public String getYstCTime() {
        return this.header.getYstCTime();
    }

    public long getSize() {
        return this.header.getSize();
    }

    public long getEquivId() {
        return this.header.getEquivId();
    }

    public String getAliasFileName() {
        return this.header.getAliasFileName();
    }

    public long getYstRDev() {
        return this.header.getYstRDev();
    }

    public long getWinCTime() {
        return this.header.getWinCTime();
    }

    public long getWinATime() {
        return this.header.getWinATime();
    }

    public long getWinMTime() {
        return this.header.getWinMTime();
    }

    public long getInbandObjId() {
        return this.header.getInbandObjId();
    }

    public long getInbandIsShrink() {
        return this.header.getInbandIsShrink();
    }

    public long getFileSizeHigh() {
        return this.header.getFileSizeHigh();
    }

    public long getShadowsObject() {
        return this.header.getShadowsObject();
    }

    public long getIsShrink() {
        return this.header.getIsShrink();
    }

    public long getSequenceNumber() {
        return this.extendedTags.getSequenceNumber();
    }

    public long getChunkId() {
        return this.extendedTags.getChunkId();
    }

    public long getNumberBytes() {
        return this.extendedTags.getNumberBytes();
    }

    public long getEccColParity() {
        return this.extendedTags.getEccColParity();
    }

    public long getEccLineParity() {
        return this.extendedTags.getEccLineParity();
    }

    public long getEccLineParityPrime() {
        return this.extendedTags.getEccLineParityPrime();
    }

    public long getParentObjectId() {
        return this.header.getParentObjectId();
    }

    public boolean isFile() {
        return this.header.isFile();
    }

    public void setFileOffset(Long foffset) {
        this.fileOffset = foffset;
    }

    public long getFileOffset() {
        return this.fileOffset;
    }
}

