/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.img2;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.ios.img2.Img2Constants;
import ghidra.file.formats.ios.img2.Img2FileSystem;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryByteProvider;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeBytesOnly;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import utilities.util.ArrayUtilities;

public class Img2FileSystemFactory
implements GFileSystemFactoryByteProvider<Img2FileSystem>,
GFileSystemProbeBytesOnly {
    public int getBytesRequired() {
        return Img2Constants.IMG2_SIGNATURE_BYTES.length;
    }

    public boolean probeStartBytes(FSRL containerFSRL, byte[] startBytes) {
        return ArrayUtilities.arrayRangesEquals((byte[])startBytes, (int)0, (byte[])Img2Constants.IMG2_SIGNATURE_BYTES, (int)0, (int)Img2Constants.IMG2_SIGNATURE_BYTES.length);
    }

    public Img2FileSystem create(FSRLRoot targetFSRL, ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        return new Img2FileSystem(targetFSRL, byteProvider, monitor);
    }
}

