/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.fbpk;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.formats.android.fbpk.FBPK;
import ghidra.file.formats.android.fbpk.FBPK_Constants;
import ghidra.file.formats.android.fbpk.FBPK_Partition;
import ghidra.file.formats.android.fbpk.FBPT;
import ghidra.file.formats.android.fbpk.FBPT_Entry;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class FBPK_Analyzer
extends AbstractAnalyzer {
    public FBPK_Analyzer() {
        super("Android FBPK Analyzer", "Annotates Android FBPK Files", AnalyzerType.BYTE_ANALYZER);
    }

    public boolean getDefaultEnablement(Program program) {
        return FBPK_Constants.isFBPK(program);
    }

    public boolean canAnalyze(Program program) {
        return FBPK_Constants.isFBPK(program);
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        Address headerAddress = program.getMinAddress();
        MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), headerAddress);
        BinaryReader reader = new BinaryReader((ByteProvider)provider, !program.getLanguage().isBigEndian());
        try {
            FBPK header = new FBPK(reader);
            DataType headerDataType = header.toDataType();
            Data headerData = program.getListing().createData(headerAddress, headerDataType);
            if (headerData == null) {
                log.appendMsg("Unable to apply FBPK data, stopping - " + headerAddress);
                return false;
            }
            Address address = headerAddress.add((long)headerDataType.getLength());
            List<FBPK_Partition> partitions = header.getPartitions();
            for (int i = 0; i < partitions.size(); ++i) {
                FBPK_Partition partition = partitions.get(i);
                DataType partitionDataType = partition.toDataType();
                Data partitionData = program.getListing().createData(address, partitionDataType);
                if (partitionData == null) {
                    log.appendMsg("Unable to apply partition data, stopping - " + address);
                    return false;
                }
                program.getListing().setComment(address, 3, partition.getName() + " - " + i);
                address = address.add((long)partitionDataType.getLength());
                if (partition.isDirectory()) {
                    if (!this.processFBPT(program, address, partition, monitor, log)) {
                        return false;
                    }
                } else if (partition.isFile()) {
                    // empty if block
                }
                address = address.getNewAddress((long)partition.getOffsetToNextPartitionTable());
            }
            return true;
        }
        catch (Exception e) {
            log.appendException((Throwable)e);
            return false;
        }
    }

    private boolean processFBPT(Program program, Address address, FBPK_Partition partition, TaskMonitor monitor, MessageLog log) throws Exception {
        FBPT fbpt = partition.getFBPT();
        DataType fbptDataType = fbpt.toDataType();
        Data fbptData = program.getListing().createData(address, fbptDataType);
        if (fbptData == null) {
            log.appendMsg("Unable to apply FBPT data, stopping - " + address);
            return false;
        }
        String comment = "FBPT\nNum of entries: " + fbpt.getNEntries();
        program.getListing().setComment(address, 3, comment);
        address = address.add((long)fbptDataType.getLength());
        return this.processFbPtEntries(program, address, fbpt, monitor, log);
    }

    private boolean processFbPtEntries(Program program, Address address, FBPT fbpt, TaskMonitor monitor, MessageLog log) throws Exception {
        for (int i = 0; i < fbpt.getEntries().size(); ++i) {
            FBPT_Entry entry = fbpt.getEntries().get(i);
            monitor.checkCanceled();
            DataType entryDataType = entry.toDataType();
            Data entryData = program.getListing().createData(address, entryDataType);
            if (entryData == null) {
                log.appendMsg("Unable to apply FBPT Entry data, stopping - " + address);
                return false;
            }
            program.getListing().setComment(address, 3, entry.getName() + " - " + i);
            address = address.add((long)entryDataType.getLength());
        }
        return true;
    }
}

